/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.entities.IntegerEntity;
import fiftyone.mobile.detection.entities.Node;
import fiftyone.mobile.detection.entities.Signature;
import fiftyone.mobile.detection.readers.BinaryReader;
import java.io.IOException;

public class SignatureV31
extends Signature {
    protected volatile Integer rank;
    private final int[] nodeOffsets;

    public SignatureV31(Dataset ds, int index, BinaryReader reader) {
        super(ds, index, reader);
        this.nodeOffsets = Signature.readOffsets(ds, reader, ds.signatureNodesCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRank() throws IOException {
        Integer localRank = this.rank;
        if (localRank == null) {
            SignatureV31 signatureV31 = this;
            synchronized (signatureV31) {
                localRank = this.rank;
                if (localRank == null) {
                    this.rank = localRank = Integer.valueOf(this.getSignatureRank());
                }
            }
        }
        return localRank;
    }

    @Override
    public int[] getNodeOffsets() {
        return this.nodeOffsets;
    }

    @Override
    protected int getSignatureLength() throws IOException {
        Node lastNode = this.dataSet.nodes.get(this.nodeOffsets[this.nodeOffsets.length - 1]);
        return lastNode.position + lastNode.getLength() + 1;
    }

    private int getSignatureRank() throws IOException {
        for (int tempRank = 0; tempRank < this.dataSet.rankedSignatureIndexes.size(); ++tempRank) {
            if (((IntegerEntity)this.dataSet.rankedSignatureIndexes.get((int)tempRank)).value != this.index) continue;
            return tempRank;
        }
        return Integer.MAX_VALUE;
    }
}

