/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.SortedList;
import fiftyone.mobile.detection.WrappedIOException;
import fiftyone.mobile.detection.entities.BaseEntity;
import fiftyone.mobile.detection.entities.Node;
import fiftyone.mobile.detection.entities.Profile;
import fiftyone.mobile.detection.entities.Property;
import fiftyone.mobile.detection.entities.Value;
import fiftyone.mobile.detection.entities.Values;
import fiftyone.mobile.detection.readers.BinaryReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class Signature
extends BaseEntity
implements Comparable<Signature> {
    private final int[] profileOffsets;
    private volatile SortedList<Integer, Values> propertyIndexToValues;
    private volatile SortedList<String, Values> propertyNameToValues;
    private volatile String deviceId;
    private volatile Value[] values;
    private volatile int length;
    private volatile Node[] nodes;
    private volatile Profile[] profiles;
    private volatile String stringValue;

    public Signature(Dataset dataSet, int index, BinaryReader reader) {
        super(dataSet, index);
        this.profileOffsets = Signature.readOffsets(dataSet, reader, dataSet.signatureProfilesCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SortedList<Integer, Values> getPropertyIndexToValues() {
        SortedList<Integer, Values> localPropertyIndexToValues = this.propertyIndexToValues;
        if (localPropertyIndexToValues == null) {
            Signature signature = this;
            synchronized (signature) {
                localPropertyIndexToValues = this.propertyIndexToValues;
                if (localPropertyIndexToValues == null) {
                    this.propertyIndexToValues = localPropertyIndexToValues = new SortedList();
                }
            }
        }
        return localPropertyIndexToValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SortedList<String, Values> getPropertyNameToValues() {
        SortedList<String, Values> localPropertyNameToValues = this.propertyNameToValues;
        if (localPropertyNameToValues == null) {
            Signature signature = this;
            synchronized (signature) {
                localPropertyNameToValues = this.propertyNameToValues;
                if (localPropertyNameToValues == null) {
                    this.propertyNameToValues = localPropertyNameToValues = new SortedList();
                }
            }
        }
        return localPropertyNameToValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profile[] getProfiles() throws IOException {
        Profile[] localProfiles = this.profiles;
        if (localProfiles == null) {
            Signature signature = this;
            synchronized (signature) {
                localProfiles = this.profiles;
                if (localProfiles == null) {
                    localProfiles = this.getProfiles(this.profileOffsets);
                    this.profiles = localProfiles;
                }
            }
        }
        return localProfiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDeviceId() throws IOException {
        String localDeviceId = this.deviceId;
        if (localDeviceId == null) {
            Signature signature = this;
            synchronized (signature) {
                localDeviceId = this.deviceId;
                if (localDeviceId == null) {
                    this.deviceId = localDeviceId = this.initGetDeviceId();
                }
            }
        }
        return localDeviceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Values getValues(Property property) throws IOException {
        Values localValues = (Values)this.getPropertyIndexToValues().get(property.index);
        if (localValues == null) {
            Signature signature = this;
            synchronized (signature) {
                localValues = (Values)this.getPropertyIndexToValues().get(property.index);
                if (localValues == null) {
                    localValues = this.getPropertyValues(property);
                    this.getPropertyIndexToValues().add(property.index, localValues);
                }
            }
        }
        return localValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Values getValues(String propertyName) throws IOException {
        Values localValues = (Values)this.getPropertyNameToValues().get(propertyName);
        if (localValues == null) {
            Signature signature = this;
            synchronized (signature) {
                localValues = (Values)this.getPropertyNameToValues().get(propertyName);
                if (localValues == null) {
                    Property property = this.dataSet.get(propertyName);
                    if (property != null) {
                        localValues = this.getValues(property);
                    }
                    this.getPropertyNameToValues().add(propertyName, localValues);
                }
            }
        }
        return localValues;
    }

    private Values getPropertyValues(Property property) throws IOException {
        Profile profileForProperty = null;
        for (Profile localProfile : this.profiles) {
            if (property.getComponent().getComponentId() != localProfile.getComponent().getComponentId()) continue;
            profileForProperty = localProfile;
            break;
        }
        return profileForProperty != null ? profileForProperty.getValues(property) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value[] getValues() throws IOException {
        Value[] localValues = this.values;
        if (localValues == null) {
            Signature signature = this;
            synchronized (signature) {
                localValues = this.values;
                if (localValues == null) {
                    localValues = this.initGetValues();
                    this.values = localValues;
                }
            }
        }
        return localValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLength() throws IOException {
        int localLength = this.length;
        if (localLength == 0) {
            Signature signature = this;
            synchronized (signature) {
                localLength = this.length;
                if (localLength == 0) {
                    this.length = localLength = this.getSignatureLength();
                }
            }
        }
        return localLength;
    }

    protected Node[] doGetNodes() throws IOException {
        Node[] nodesLocal = new Node[this.getNodeOffsets().length];
        for (int i = 0; i < this.getNodeOffsets().length; ++i) {
            nodesLocal[i] = this.dataSet.nodes.get(this.getNodeOffsets()[i]);
        }
        return nodesLocal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node[] getNodes() throws IOException {
        Node[] localNodes = this.nodes;
        if (localNodes == null) {
            Signature signature = this;
            synchronized (signature) {
                localNodes = this.nodes;
                if (localNodes == null) {
                    localNodes = this.doGetNodes();
                    this.nodes = localNodes;
                }
            }
        }
        return localNodes;
    }

    protected static int[] readOffsets(Dataset dataSet, BinaryReader reader, int length) {
        reader.list.clear();
        for (int i = 0; i < length; ++i) {
            int profileIndex = reader.readInt32();
            if (profileIndex < 0) continue;
            reader.list.add(profileIndex);
        }
        int[] array = new int[reader.list.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = reader.list.get(i);
        }
        return array;
    }

    public void init() throws IOException {
        if (this.nodes == null) {
            this.nodes = this.getNodes();
        }
        if (this.profiles == null) {
            this.profiles = this.getProfiles();
        }
        if (this.values == null) {
            this.values = this.getValues();
        }
        if (this.deviceId == null) {
            this.deviceId = this.getDeviceId();
        }
        if (this.length == 0) {
            this.length = this.getSignatureLength();
        }
    }

    private String initGetDeviceId() throws IOException {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.getProfiles().length; ++i) {
            builder.append(this.getProfiles()[i].profileId);
            if (i >= this.getProfiles().length - 1) continue;
            builder.append("-");
        }
        return builder.toString();
    }

    public SortedList<String, List<String>> getPropertyValuesAsStrings() throws IOException {
        int numberOfValues = this.getValues().length;
        SortedList<String, List<String>> list = new SortedList<String, List<String>>(numberOfValues, 1.0f);
        for (Value value : this.getValues()) {
            if (!list.containsKey(value.getProperty().getName())) {
                list.add(value.getProperty().getName(), new ArrayList());
            }
            ((List)list.get(value.getProperty().getName())).add(value.getName());
        }
        return list;
    }

    private Value[] initGetValues() throws IOException {
        ArrayList<Value> result = new ArrayList<Value>();
        for (Profile profile : this.getProfiles()) {
            result.addAll(Arrays.asList(profile.getValues()));
        }
        return result.toArray(new Value[result.size()]);
    }

    private Profile[] getProfiles(int[] profileIndexes) throws IOException {
        ArrayList<Profile> prof = new ArrayList<Profile>();
        for (int profileIndex : profileIndexes) {
            prof.add(this.getDataSet().getProfiles().get(profileIndex));
        }
        return prof.toArray(new Profile[prof.size()]);
    }

    @Override
    public int compareTo(List<Node> nodes) throws IOException {
        int tempLength = Math.min(this.getNodeOffsets().length, nodes.size());
        for (int i = 0; i < tempLength; ++i) {
            int difference = this.getNodeOffsets()[i] - nodes.get(i).getIndex();
            if (difference == 0) continue;
            return difference;
        }
        if (this.getNodeOffsets().length < nodes.size()) {
            return -1;
        }
        if (this.getNodeOffsets().length > nodes.size()) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compareTo(Signature other) {
        try {
            int tempLength = Math.min(this.getNodeOffsets().length, other.getNodeOffsets().length);
            for (int i = 0; i < tempLength; ++i) {
                int difference = this.getNodeOffsets()[i] - other.getNodeOffsets()[i];
                if (difference == 0) continue;
                return difference;
            }
            if (this.getNodeOffsets().length < other.getNodeOffsets().length) {
                return -1;
            }
            if (this.getNodeOffsets().length > other.getNodeOffsets().length) {
                return 1;
            }
        }
        catch (IOException ex) {
            throw new WrappedIOException(ex.getMessage());
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String localStringValue = this.stringValue;
        if (localStringValue == null) {
            Signature signature = this;
            synchronized (signature) {
                localStringValue = this.stringValue;
                if (localStringValue == null) {
                    try {
                        byte[] buffer = new byte[this.getLength()];
                        for (Node n : this.getNodes()) {
                            n.addCharacters(buffer);
                        }
                        for (int i = 0; i < buffer.length; ++i) {
                            if (buffer[i] != 0) continue;
                            buffer[i] = 32;
                        }
                        this.stringValue = localStringValue = new String(buffer, "US-ASCII");
                    }
                    catch (IOException ex) {
                        throw new WrappedIOException(ex.getMessage());
                    }
                }
            }
        }
        return localStringValue;
    }

    public abstract int[] getNodeOffsets() throws IOException;

    protected abstract int getSignatureLength() throws IOException;

    public abstract int getRank() throws IOException;
}

