/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.SortedList;
import fiftyone.mobile.detection.entities.BaseEntity;
import fiftyone.mobile.detection.entities.Component;
import fiftyone.mobile.detection.entities.Property;
import fiftyone.mobile.detection.entities.Signature;
import fiftyone.mobile.detection.entities.Value;
import fiftyone.mobile.detection.entities.Values;
import fiftyone.mobile.detection.readers.BinaryReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeSet;

public abstract class Profile
extends BaseEntity
implements Comparable<Profile> {
    private final int componentIndex;
    protected volatile int[] signatureIndexes;
    public final int profileId;
    protected volatile int[] valueIndexes;
    private final Value[] emptyValues = new Value[0];
    private volatile Component component;
    private volatile Property[] properties;
    private volatile Signature[] signatures;
    private volatile Value[] values;
    private volatile SortedList<Integer, Values> propertyIndexToValues;
    private volatile String stringValue;
    private static final Comparator<Value> propertyComparator = new Comparator<Value>(){

        @Override
        public int compare(Value v1, Value v2) {
            try {
                if (v1.getProperty().displayOrder < v2.getProperty().displayOrder) {
                    return 1;
                }
                if (v1.getProperty().displayOrder > v2.getProperty().displayOrder) {
                    return -1;
                }
                return 0;
            }
            catch (IOException e) {
                return 0;
            }
        }
    };

    public Profile(Dataset dataSet, int offset, BinaryReader reader) {
        super(dataSet, offset);
        this.componentIndex = reader.readByte();
        this.profileId = reader.readInt32();
    }

    @Override
    public int compareTo(Profile other) {
        return this.profileId - other.profileId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getComponent() throws IOException {
        Component localComponent = this.component;
        if (localComponent == null) {
            Profile profile = this;
            synchronized (profile) {
                localComponent = this.component;
                if (localComponent == null) {
                    this.component = localComponent = this.getDataSet().getComponents().get(this.componentIndex);
                }
            }
        }
        return localComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Property[] getProperties() throws IOException {
        Property[] localProperties = this.properties;
        if (localProperties == null) {
            Profile profile = this;
            synchronized (profile) {
                localProperties = this.properties;
                if (localProperties == null) {
                    localProperties = this.doGetProperties();
                    this.properties = localProperties;
                }
            }
        }
        return localProperties;
    }

    private Property[] doGetProperties() throws IOException {
        TreeSet<Property> tree = new TreeSet<Property>(new Comparator<Property>(){

            @Override
            public int compare(Property o1, Property o2) {
                try {
                    return o1.getName().compareTo(o2.getName());
                }
                catch (IOException ex) {
                    return 0;
                }
            }
        });
        for (Value value : this.getValues()) {
            tree.add(value.getProperty());
        }
        return tree.toArray(new Property[tree.size()]);
    }

    public Values getValues(String propertyName) throws IOException {
        return this.getValues(this.dataSet.properties.get(propertyName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Values getValues(Property property) throws IOException {
        Values localValues = (Values)this.getPropertyIndexToValues().get(property.getIndex());
        if (localValues == null) {
            Profile profile = this;
            synchronized (profile) {
                localValues = (Values)this.getPropertyIndexToValues().get(property.getIndex());
                if (localValues == null) {
                    localValues = this.getPropertyValues(property);
                    this.getPropertyIndexToValues().add(property.getIndex(), localValues);
                }
            }
        }
        return localValues;
    }

    private Values getPropertyValues(Property property) throws IOException {
        Value[] result;
        int end;
        int start = Arrays.binarySearch(this.getValueIndexes(), property.firstValueIndex);
        if (start < 0) {
            start ^= 0xFFFFFFFF;
        }
        if ((end = Arrays.binarySearch(this.getValueIndexes(), start, this.getValueIndexes().length, property.getLastIndexValue())) < 0 && ((end ^= 0xFFFFFFFF) >= this.getValueIndexes().length || this.getValueIndexes()[end] > property.getLastIndexValue())) {
            --end;
        }
        if (start > end) {
            result = this.emptyValues;
        } else {
            result = new Value[end - start + 1];
            int i = start;
            int v = 0;
            while (i <= end) {
                Value value;
                result[v] = value = this.dataSet.values.get(this.getValueIndexes()[i]);
                ++i;
                ++v;
            }
        }
        return new Values(property, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Signature[] getSignatures() throws IOException {
        Signature[] localSignatures = this.signatures;
        if (localSignatures == null) {
            Profile profile = this;
            synchronized (profile) {
                localSignatures = this.signatures;
                if (localSignatures == null) {
                    localSignatures = this.doGetSignatures();
                    this.signatures = localSignatures;
                }
            }
        }
        return localSignatures;
    }

    private Signature[] doGetSignatures() throws IOException {
        Signature[] array = new Signature[this.signatureIndexes.length];
        for (int i = 0; i < this.signatureIndexes.length; ++i) {
            array[i] = this.getDataSet().getSignatures().get(this.signatureIndexes[i]);
        }
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value[] getValues() throws IOException {
        Value[] localValues = this.values;
        if (localValues == null) {
            Profile profile = this;
            synchronized (profile) {
                localValues = this.values;
                if (localValues == null) {
                    localValues = this.doGetValues();
                    this.values = localValues;
                }
            }
        }
        return localValues;
    }

    private Value[] doGetValues() throws IOException {
        Value[] array = new Value[this.getValueIndexes().length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.getDataSet().getValues().get(this.getValueIndexes()[i]);
        }
        return array;
    }

    public void init() throws IOException {
        if (this.properties == null) {
            this.properties = this.doGetProperties();
        }
        if (this.values == null) {
            this.values = this.doGetValues();
        }
        if (this.signatures == null) {
            this.signatures = this.doGetSignatures();
        }
        if (this.component == null) {
            this.component = this.getDataSet().getComponents().get(this.componentIndex);
        }
        for (Property property : this.properties) {
            this.getPropertyIndexToValues().add(property.getIndex(), this.getPropertyValues(property));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SortedList<Integer, Values> getPropertyIndexToValues() {
        SortedList<Integer, Values> localPropertyIndexToValues = this.propertyIndexToValues;
        if (localPropertyIndexToValues == null) {
            Profile profile = this;
            synchronized (profile) {
                localPropertyIndexToValues = this.propertyIndexToValues;
                if (localPropertyIndexToValues == null) {
                    this.propertyIndexToValues = localPropertyIndexToValues = new SortedList();
                }
            }
        }
        return localPropertyIndexToValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String localStringValue = this.stringValue;
        if (localStringValue == null) {
            Profile profile = this;
            synchronized (profile) {
                localStringValue = this.stringValue;
                if (localStringValue == null) {
                    ArrayList<Value> list = new ArrayList<Value>();
                    try {
                        for (int i = 0; i < this.getValues().length; ++i) {
                            int tempIndex;
                            Value value = this.getValues()[i];
                            if (value.getProperty().displayOrder <= 0 || value.getName().contains("Unknown") || (tempIndex = Collections.binarySearch(list, value, propertyComparator)) >= 0) continue;
                            list.add(~tempIndex, value);
                        }
                        if (list.size() > 0) {
                            StringBuilder sb = new StringBuilder();
                            for (int i = 0; i < list.size(); ++i) {
                                sb.append(((Value)list.get(i)).toString());
                                if (i >= list.size() - 1) continue;
                                sb.append("/");
                            }
                            this.stringValue = localStringValue = sb.toString();
                        } else {
                            this.stringValue = localStringValue = String.valueOf(this.profileId);
                        }
                    }
                    catch (IOException e) {
                        this.stringValue = localStringValue = String.valueOf(this.profileId);
                    }
                }
            }
        }
        return localStringValue;
    }

    public abstract int[] getValueIndexes() throws IOException;

    public abstract int[] getSignatureIndexes() throws IOException;
}

