/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.readers.BinaryReader;

public class BaseEntity {
    private static final int[] POWERS = new int[]{1, 10, 100, 1000, 10000};
    public final Dataset dataSet;
    public final int index;

    public static boolean getIsNumeric(byte value) {
        return value >= 48 && value <= 57;
    }

    BaseEntity(Dataset dataSet, int offsetOrIndex) {
        this.dataSet = dataSet;
        this.index = offsetOrIndex;
    }

    public int compareTo(int offsetOrIndex) {
        return this.index - offsetOrIndex;
    }

    public int compareTo(BaseEntity other) {
        return this.compareTo(other.index);
    }

    protected static int[] readIntegerArray(BinaryReader reader, int count) {
        int[] array = new int[count];
        for (int i = 0; i < count; ++i) {
            array[i] = reader.readInt32();
        }
        return array;
    }

    public static int getNumber(byte[] array, int start, int length) {
        int value = 0;
        int i = start + length - 1;
        for (int p = 0; i >= start && p < POWERS.length; --i, ++p) {
            value += POWERS[p] * (array[i] - 48);
        }
        return value;
    }

    protected Dataset getDataSet() {
        return this.dataSet;
    }

    public int getIndex() {
        return this.index;
    }
}

