/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection;

import fiftyone.mobile.detection.MatchState;
import fiftyone.mobile.detection.entities.Node;
import fiftyone.mobile.detection.entities.Profile;
import fiftyone.mobile.detection.entities.Signature;
import fiftyone.properties.MatchMethods;
import java.io.IOException;

public class MatchResult {
    protected long elapsed;
    protected MatchMethods method;
    protected int nodesEvaluated;
    protected int rootNodesEvaluated;
    protected Signature signature;
    protected int signaturesCompared;
    protected int signaturesRead;
    protected int stringsRead;
    protected int closestSignaturesCount;
    protected int lowestScore;
    protected String targetUserAgent;
    protected Node[] nodes;
    protected Profile[] profiles;

    public long getElapsed() {
        return this.elapsed;
    }

    public MatchMethods getMethod() {
        return this.method;
    }

    public int getNodesEvaluated() {
        return this.nodesEvaluated;
    }

    public int getRootNodesEvaluated() {
        return this.rootNodesEvaluated;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public int getSignaturesCompared() {
        return this.signaturesCompared;
    }

    public int getSignaturesRead() {
        return this.signaturesRead;
    }

    public int getStringsRead() {
        return this.stringsRead;
    }

    public int getClosestSignaturesCount() {
        return this.closestSignaturesCount;
    }

    public int getLowestScore() {
        return this.lowestScore;
    }

    public String getTargetUserAgent() {
        return this.targetUserAgent;
    }

    Node[] getNodes() {
        return this.nodes;
    }

    public Profile[] getProfiles() throws IOException {
        return this.profiles;
    }

    protected MatchResult() {
    }

    MatchResult(MatchState source) throws IOException {
        this.elapsed = source.getElapsed();
        this.method = source.getMethod();
        this.nodesEvaluated = source.getNodesEvaluated();
        this.rootNodesEvaluated = source.getRootNodesEvaluated();
        this.signature = source.getSignature();
        this.signaturesCompared = source.getSignaturesCompared();
        this.signaturesRead = source.getSignaturesRead();
        this.stringsRead = source.getStringsRead();
        this.closestSignaturesCount = source.getClosestSignaturesCount();
        this.lowestScore = source.getLowestScore();
        this.targetUserAgent = source.getTargetUserAgent();
        this.profiles = (Profile[])source.getProfiles().clone();
        this.nodes = source.getNodes();
    }
}

