/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.MatchResult;
import fiftyone.mobile.detection.MatchState;
import fiftyone.mobile.detection.Provider;
import fiftyone.mobile.detection.Utilities;
import fiftyone.mobile.detection.entities.Node;
import fiftyone.mobile.detection.entities.Profile;
import fiftyone.mobile.detection.entities.Property;
import fiftyone.mobile.detection.entities.Signature;
import fiftyone.mobile.detection.entities.Value;
import fiftyone.mobile.detection.entities.Values;
import fiftyone.properties.MatchMethods;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class Match {
    final Provider provider;
    final MatchState state;
    private MatchResult matchResult;
    private volatile Profile[] overriddenProfiles;

    void setResult(MatchResult value) {
        this.matchResult = value;
    }

    MatchResult getResult() {
        return this.matchResult;
    }

    public Dataset getDataSet() {
        return this.provider.dataSet;
    }

    public String getTargetUserAgent() {
        return this.getResult().getTargetUserAgent();
    }

    public long getElapsed() {
        return this.getResult().getElapsed();
    }

    public Signature getSignature() {
        return this.getResult().getSignature();
    }

    public MatchMethods getMethod() {
        return this.getResult().getMethod();
    }

    public int getClosestSignaturesCount() {
        return this.getResult().getClosestSignaturesCount();
    }

    public int getSignaturesCompared() {
        return this.getResult().getSignaturesCompared();
    }

    public int getSignaturesRead() {
        return this.getResult().getSignaturesRead();
    }

    public int getRootNodesEvaluated() {
        return this.getResult().getRootNodesEvaluated();
    }

    public int getNodesEvaluated() {
        return this.getResult().getNodesEvaluated();
    }

    public int getNodesFound() {
        return this.getResult().getNodes().length;
    }

    public int getStringsRead() {
        return this.getResult().getStringsRead();
    }

    public Profile[] getProfiles() throws IOException {
        return this.overriddenProfiles == null ? this.getResult().getProfiles() : this.getOverriddenProfiles();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Profile[] getOverriddenProfiles() throws IOException {
        Profile[] result = this.overriddenProfiles;
        if (result == null && this.getSignature() != null) {
            Match match = this;
            synchronized (match) {
                result = this.overriddenProfiles;
                if (result == null) {
                    result = new Profile[this.getResult().getProfiles().length];
                    System.arraycopy(this.getResult().getProfiles(), 0, result, 0, result.length);
                    this.overriddenProfiles = result;
                }
            }
        }
        return result;
    }

    public int getDifference() {
        int score = this.getResult().getLowestScore();
        return score >= 0 ? score : 0;
    }

    public String getDeviceId() throws IOException {
        String result;
        if (this.getSignature() != null) {
            result = this.getSignature().getDeviceId();
        } else {
            String[] profileIds = new String[this.getProfiles().length];
            for (int i = 0; i < profileIds.length; ++i) {
                profileIds[i] = Integer.toString(this.getProfiles()[i].profileId);
            }
            result = Utilities.joinString("-", profileIds);
        }
        return result;
    }

    public byte[] getDeviceIdAsByteArray() throws IOException {
        byte[] result = new byte[this.getProfiles().length * 32 / 8];
        ByteBuffer bb = ByteBuffer.wrap(result);
        for (Profile tempProfile : this.getProfiles()) {
            bb.putInt(tempProfile.profileId);
        }
        return result;
    }

    public String getUserAgent() {
        return this.getSignature() != null ? this.getSignature().toString() : null;
    }

    @Deprecated
    public Map<String, String[]> getResults() throws IOException {
        HashMap<String, String[]> results = new HashMap<String, String[]>();
        for (Profile profile : this.getProfiles()) {
            if (profile == null) continue;
            for (Property property : profile.getProperties()) {
                Value[] values = profile.getValues();
                ArrayList<String> strings = new ArrayList<String>();
                for (Value value : values) {
                    if (value.getProperty() != property) continue;
                    strings.add(value.getName());
                }
                results.put(property.getName(), strings.toArray(new String[strings.size()]));
            }
        }
        results.put("Difference", new String[]{Integer.toString(this.getDifference())});
        results.put("Nodes", new String[]{this.toString()});
        results.put("Id", new String[]{this.getDeviceId()});
        return results;
    }

    public Values getValues(Property property) throws IOException {
        Values value = null;
        if (property != null) {
            for (Profile profile : this.getProfiles()) {
                if (profile.getComponent().getComponentId() != property.getComponent().getComponentId()) continue;
                value = profile.getValues(property);
                break;
            }
            if (value == null) {
                value = property.getComponent().getDefaultProfile().getValues(property);
            }
        }
        return value;
    }

    public Values getValues(String propertyName) throws IOException {
        return this.getValues(this.getDataSet().get(propertyName));
    }

    Match(Provider provider) {
        this.provider = provider;
        this.state = new MatchState(this);
        this.matchResult = this.state;
    }

    Match(Provider provider, String targetUserAgent) throws UnsupportedEncodingException {
        this(provider);
        this.state.init(targetUserAgent);
    }

    void reset() {
        this.state.reset();
        this.overriddenProfiles = null;
    }

    public void updateProfile(int profileId) throws IOException {
        Profile newProfile = this.getDataSet().findProfile(profileId);
        if (newProfile != null) {
            for (int i = 0; i < this.getOverriddenProfiles().length; ++i) {
                if (this.getOverriddenProfiles()[i].getComponent().getComponentId() != newProfile.getComponent().getComponentId()) continue;
                this.getOverriddenProfiles()[i] = newProfile;
                break;
            }
        }
    }

    public String toString() {
        if (this.state.getNodesList() != null && this.state.getNodes().length > 0) {
            try {
                byte[] value = new byte[this.getTargetUserAgent().length()];
                for (Node node : this.state.getNodes()) {
                    node.addCharacters(value);
                }
                for (int i = 0; i < value.length; ++i) {
                    if (value[i] != 0) continue;
                    value[i] = 95;
                }
                return new String(value, "US-ASCII");
            }
            catch (IOException e) {
                return super.toString();
            }
        }
        return super.toString();
    }
}

