/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection;

import fiftyone.mobile.detection.ClosestScore;
import fiftyone.mobile.detection.MatchState;
import fiftyone.mobile.detection.MostFrequentFilter;
import fiftyone.mobile.detection.NearestScore;
import fiftyone.mobile.detection.RankedSignatureIterator;
import fiftyone.mobile.detection.WrappedIOException;
import fiftyone.mobile.detection.entities.Component;
import fiftyone.mobile.detection.entities.Node;
import fiftyone.mobile.detection.search.SearchResult;
import fiftyone.properties.MatchMethods;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;

class Controller {
    private static final Comparator<Node> nodeComparator = new Comparator<Node>(){

        @Override
        public int compare(Node o1, Node o2) {
            try {
                int l0 = o1.getRankedSignatureIndexes().length;
                int l1 = o2.getRankedSignatureIndexes().length;
                if (l0 < l1) {
                    return -1;
                }
                if (l0 > l1) {
                    return 1;
                }
                if (l0 == l1) {
                    if (o1.position > o2.position) {
                        return 1;
                    }
                    if (o1.position < o2.position) {
                        return -1;
                    }
                }
            }
            catch (IOException ex) {
                throw new WrappedIOException(ex.getMessage());
            }
            return 0;
        }
    };
    private static final NearestScore nearest = new NearestScore();
    private static final ClosestScore closest = new ClosestScore();

    Controller() {
    }

    static void match(MatchState state) throws IOException {
        if (state.getDataSet().getDisposed()) {
            throw new IllegalStateException("Data Set has been disposed and can't be used for match");
        }
        if (state.getTargetUserAgentArray().length == 0 || state.getTargetUserAgentArray().length < state.getDataSet().getMinUserAgentLength()) {
            Controller.matchDefault(state);
        } else {
            Controller.evaluate(state);
            int signatureIndex = Controller.getExactSignatureIndex(state);
            if (signatureIndex >= 0) {
                state.setSignature(state.getDataSet().signatures.get(signatureIndex));
                state.setMethod(MatchMethods.EXACT);
                state.setLowestScore(0);
            } else {
                Controller.evaluateNumeric(state);
                signatureIndex = Controller.getExactSignatureIndex(state);
                if (signatureIndex >= 0) {
                    state.setSignature(state.getDataSet().signatures.get(signatureIndex));
                    state.setMethod(MatchMethods.NUMERIC);
                } else if (state.getNodesList().size() > 0) {
                    RankedSignatureIterator closestSignatures = Controller.getClosestSignatures(state);
                    nearest.evaluateSignatures(state, closestSignatures);
                    if (state.getSignature() != null) {
                        state.setMethod(MatchMethods.NEAREST);
                    } else {
                        closest.evaluateSignatures(state, closestSignatures);
                        state.setMethod(MatchMethods.CLOSEST);
                    }
                }
            }
            if (state.getProfiles().length == 0 && state.getSignature() == null) {
                Controller.matchDefault(state);
            }
        }
    }

    private static void evaluateNumeric(MatchState state) throws IOException {
        state.resetNextCharacterPositionIndex();
        int existingNodeIndex = state.getNodesList().size() - 1;
        while (state.nextCharacterPositionIndex > 0) {
            if (existingNodeIndex < 0 || state.getNodesList().get((int)existingNodeIndex).getRoot().position < state.nextCharacterPositionIndex) {
                state.incrRootNodesEvaluated();
                Node node = state.getDataSet().rootNodes.get(state.nextCharacterPositionIndex).getCompleteNumericNode(state);
                if (node != null && !node.getIsOverlap(state)) {
                    existingNodeIndex = state.insertNode(node) - 1;
                    state.nextCharacterPositionIndex = node.position;
                    continue;
                }
                --state.nextCharacterPositionIndex;
                continue;
            }
            state.nextCharacterPositionIndex = state.getNodesList().get((int)existingNodeIndex).position;
            --existingNodeIndex;
        }
    }

    static void matchDefault(MatchState state) throws IOException {
        state.setMethod(MatchMethods.NONE);
        state.getExplicitProfiles().clear();
        for (Component component : state.getDataSet().components) {
            state.getExplicitProfiles().add(component.getDefaultProfile());
        }
    }

    private static void evaluate(MatchState state) throws IOException {
        while (state.nextCharacterPositionIndex >= 0) {
            state.incrRootNodesEvaluated();
            Node node = state.getDataSet().rootNodes.get(state.nextCharacterPositionIndex).getCompleteNode(state);
            if (node != null) {
                state.getNodesList().add(0, node);
                state.nextCharacterPositionIndex = node.nextCharacterPosition;
                continue;
            }
            --state.nextCharacterPositionIndex;
        }
    }

    private static int getExactSignatureIndex(MatchState state) throws IOException {
        SearchResult result = state.match.getDataSet().getSignatureSearch().binarySearch(state.getNodesList());
        state.signaturesRead += result.getIterations();
        return result.getIndex();
    }

    private static RankedSignatureIterator getClosestSignatures(final MatchState state) throws IOException {
        RankedSignatureIterator result;
        if (state.getNodesList().size() == 1) {
            result = new RankedSignatureIterator(){
                final int[] rankedSignatureIndexes;
                int index;
                {
                    this.rankedSignatureIndexes = state.getNodesList().get(0).getRankedSignatureIndexes();
                    this.index = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.index < this.rankedSignatureIndexes.length;
                }

                @Override
                public int size() {
                    return this.rankedSignatureIndexes.length;
                }

                @Override
                public int next() {
                    int value = this.rankedSignatureIndexes[this.index];
                    ++this.index;
                    return value;
                }

                @Override
                public void reset() {
                    this.index = 0;
                }
            };
        } else {
            final MostFrequentFilter filter = new MostFrequentFilter(state);
            result = new RankedSignatureIterator(){
                final List<Integer> rankedSignatureIndexes;
                int index;
                {
                    this.rankedSignatureIndexes = filter;
                    this.index = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.index < this.rankedSignatureIndexes.size();
                }

                @Override
                public int size() {
                    return this.rankedSignatureIndexes.size();
                }

                @Override
                public int next() {
                    int value = this.rankedSignatureIndexes.get(this.index);
                    ++this.index;
                    return value;
                }

                @Override
                public void reset() {
                    this.index = 0;
                }
            };
        }
        state.closestSignaturesCount += result.size();
        return result;
    }
}

