/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.cache;

import fiftyone.mobile.detection.cache.ICache;
import fiftyone.mobile.detection.cache.ICacheBuilder;
import fiftyone.mobile.detection.cache.ILoadingCache;
import fiftyone.mobile.detection.cache.IValueLoader;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class LruCache<K, V>
implements ILoadingCache<K, V> {
    private IValueLoader<K, V> loader;
    private final ConcurrentHashMap<K, CachedItem> hashMap;
    final CacheLinkedList[] linkedLists;
    final Random random = new Random();
    private int cacheSize;
    private final AtomicLong misses = new AtomicLong(0L);
    private final AtomicLong requests = new AtomicLong(0L);

    public void setCacheLoader(IValueLoader<K, V> loader) {
        this.loader = loader;
    }

    public LruCache(int cacheSize) {
        this(cacheSize, null);
    }

    public LruCache(int cacheSize, IValueLoader<K, V> loader) {
        this(cacheSize, Runtime.getRuntime().availableProcessors(), loader);
    }

    public LruCache(int cacheSize, int concurrency, IValueLoader<K, V> loader) {
        if (concurrency <= 0) {
            throw new IllegalArgumentException("Concurrency must be a positive integer greater than 0.");
        }
        this.cacheSize = cacheSize;
        this.loader = loader;
        this.hashMap = new ConcurrentHashMap(cacheSize);
        this.linkedLists = (CacheLinkedList[])Array.newInstance(CacheLinkedList.class, concurrency);
        for (int i = 0; i < this.linkedLists.length; ++i) {
            this.linkedLists[i] = new CacheLinkedList(this);
        }
    }

    @Override
    public long getCacheSize() {
        return this.cacheSize;
    }

    @Override
    public long getCacheMisses() {
        return this.misses.get();
    }

    @Override
    public long getCacheRequests() {
        return this.requests.get();
    }

    @Override
    public double getPercentageMisses() {
        return this.misses.doubleValue() / this.requests.doubleValue();
    }

    @Override
    public V get(K key) {
        try {
            return this.get(key, this.loader);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public V get(K key, IValueLoader<K, V> loader) throws IOException {
        boolean added = false;
        this.requests.incrementAndGet();
        CachedItem node = this.hashMap.get(key);
        if (node == null) {
            this.misses.incrementAndGet();
            CachedItem newNode = new CachedItem(this.GetRandomLinkedList(), key, loader.load(key));
            node = this.hashMap.putIfAbsent(key, newNode);
            if (node == null) {
                added = true;
                newNode.list.addNew(newNode);
                node = newNode;
            }
        }
        if (!added) {
            node.list.moveFirst(node);
        }
        return node.value;
    }

    @Override
    public void resetCache() {
        this.hashMap.clear();
        this.misses.set(0L);
        this.requests.set(0L);
        for (int i = 0; i < this.linkedLists.length; ++i) {
            this.linkedLists[i].clear();
        }
    }

    private CacheLinkedList GetRandomLinkedList() {
        return this.linkedLists[this.random.nextInt(this.linkedLists.length)];
    }

    public static ICacheBuilder builder() {
        return new LruBuilder();
    }

    public static class LruBuilder
    implements ICacheBuilder {
        @Override
        public ICache build(int size) {
            return new LruCache(size);
        }
    }

    class CacheLinkedList {
        LruCache cache = null;
        CachedItem first = null;
        CachedItem last = null;

        public CacheLinkedList(LruCache cache) {
            this.cache = cache;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addNew(CachedItem item) {
            CacheLinkedList cacheLinkedList;
            boolean added = false;
            if (item != this.first) {
                cacheLinkedList = this;
                synchronized (cacheLinkedList) {
                    if (item != this.first) {
                        if (this.first == null) {
                            this.first = item;
                            this.last = item;
                        } else {
                            item.next = this.first;
                            this.first.previous = item;
                            this.first = item;
                            added = true;
                        }
                        item.isValid = true;
                    }
                }
            }
            if (added && this.cache.hashMap.size() > this.cache.cacheSize) {
                cacheLinkedList = this;
                synchronized (cacheLinkedList) {
                    if (this.cache.hashMap.size() > this.cache.cacheSize) {
                        this.last.isValid = false;
                        this.cache.hashMap.remove(this.last.key);
                        this.last = this.last.previous;
                        this.last.next = null;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void moveFirst(CachedItem item) {
            if (item != this.first && item.isValid) {
                CacheLinkedList cacheLinkedList = this;
                synchronized (cacheLinkedList) {
                    if (item != this.first && item.isValid) {
                        if (item == this.last) {
                            this.last = item.previous;
                            this.last.next = null;
                        } else {
                            item.previous.next = item.next;
                            item.next.previous = item.previous;
                        }
                        item.next = this.first;
                        item.previous = null;
                        this.first.previous = item;
                        this.first = item;
                    }
                }
            }
        }

        void clear() {
            this.first = null;
            this.last = null;
        }
    }

    class CachedItem {
        final K key;
        final V value;
        CachedItem next;
        CachedItem previous;
        final CacheLinkedList list;
        boolean isValid;

        public CachedItem(CacheLinkedList list, K key, V value) {
            this.list = list;
            this.key = key;
            this.value = value;
        }
    }
}

