/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.readers;

import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;

public class BinaryReader
implements Closeable {
    public final List<Integer> list = new ArrayList<Integer>();
    private ByteBuffer byteBuffer;
    private FileChannel channel;

    public BinaryReader(byte[] data) {
        this.byteBuffer = ByteBuffer.wrap(data);
        this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public BinaryReader(FileInputStream fileInputStream) throws IOException {
        this.channel = fileInputStream.getChannel();
        this.byteBuffer = this.channel.map(FileChannel.MapMode.READ_ONLY, 0L, this.channel.size());
        this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public BinaryReader(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
        this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public void setPos(int pos) {
        this.byteBuffer.position(pos);
    }

    public int getPos() {
        return this.byteBuffer.position();
    }

    public byte readByte() {
        return this.byteBuffer.get();
    }

    public short readInt16() {
        return this.byteBuffer.getShort();
    }

    public int readUInt16() {
        int s = this.byteBuffer.getShort();
        int intVal = s >= 0 ? s : 65536 + s;
        return intVal;
    }

    public int readInt32() {
        return this.byteBuffer.getInt();
    }

    public boolean readBoolean() {
        return this.byteBuffer.get() != 0;
    }

    public byte[] readBytes(int length) {
        byte[] bytes = new byte[length];
        this.byteBuffer.get(bytes);
        return bytes;
    }

    @Override
    public void close() {
        this.byteBuffer = null;
        if (this.channel != null) {
            try {
                this.channel.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

