/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.factories;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.entities.NodeIndex;
import fiftyone.mobile.detection.readers.BinaryReader;

public class NodeFactoryShared {
    private static final int NODE_INDEX_LENGTH_V31 = 9;
    private static final int NODE_INDEX_LENGTH_V32 = 8;

    public static int getNodeIndexLengthV31() {
        return 9;
    }

    public static int getNodeIndexLengthV32() {
        return 8;
    }

    public static NodeIndex[] readNodeIndexesV31(Dataset dataSet, BinaryReader reader, int offset, int count) {
        NodeIndex[] array = new NodeIndex[count];
        offset += 2;
        for (int i = 0; i < array.length; ++i) {
            boolean isString = reader.readBoolean();
            array[i] = new NodeIndex(dataSet, offset, isString, NodeFactoryShared.readValue(reader, isString), reader.readInt32());
            offset += 9;
        }
        return array;
    }

    public static NodeIndex[] readNodeIndexesV32(Dataset dataSet, BinaryReader reader, int offset, int count) {
        NodeIndex[] array = new NodeIndex[count];
        offset += 2;
        for (int i = 0; i < array.length; ++i) {
            int index = reader.readInt32();
            boolean isString = index < 0;
            array[i] = new NodeIndex(dataSet, offset, isString, NodeFactoryShared.readValue(reader, isString), Math.abs(index));
            offset += 8;
        }
        return array;
    }

    private static byte[] readValue(BinaryReader reader, boolean isString) {
        byte[] byteValue = reader.readBytes(4);
        if (!isString) {
            int i;
            for (i = 0; i < byteValue.length && byteValue[i] != 0; ++i) {
            }
            byte[] tempValue = new byte[i];
            System.arraycopy(byteValue, 0, tempValue, 0, i);
            byteValue = tempValue;
        }
        return byteValue;
    }
}

