/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.factories;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.entities.AsciiString;
import fiftyone.mobile.detection.entities.Component;
import fiftyone.mobile.detection.entities.Map;
import fiftyone.mobile.detection.entities.Modes;
import fiftyone.mobile.detection.entities.Node;
import fiftyone.mobile.detection.entities.Profile;
import fiftyone.mobile.detection.entities.ProfileOffset;
import fiftyone.mobile.detection.entities.Signature;
import fiftyone.mobile.detection.entities.Value;
import fiftyone.mobile.detection.entities.memory.MemoryFixedList;
import fiftyone.mobile.detection.entities.memory.MemoryIntegerList;
import fiftyone.mobile.detection.entities.memory.MemoryVariableList;
import fiftyone.mobile.detection.entities.memory.PropertiesList;
import fiftyone.mobile.detection.factories.AsciiStringFactory;
import fiftyone.mobile.detection.factories.CommonFactory;
import fiftyone.mobile.detection.factories.ComponentFactoryV31;
import fiftyone.mobile.detection.factories.ComponentFactoryV32;
import fiftyone.mobile.detection.factories.MapFactory;
import fiftyone.mobile.detection.factories.ProfileOffsetFactory;
import fiftyone.mobile.detection.factories.PropertyFactory;
import fiftyone.mobile.detection.factories.RootNodeFactory;
import fiftyone.mobile.detection.factories.SignatureFactoryV31;
import fiftyone.mobile.detection.factories.SignatureFactoryV32;
import fiftyone.mobile.detection.factories.ValueFactory;
import fiftyone.mobile.detection.factories.memory.NodeMemoryFactoryV31;
import fiftyone.mobile.detection.factories.memory.NodeMemoryFactoryV32;
import fiftyone.mobile.detection.factories.memory.ProfileMemoryFactory;
import fiftyone.mobile.detection.readers.BinaryReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Date;

public class MemoryFactory {
    public static Dataset create(byte[] data) throws IOException {
        return MemoryFactory.create(data, false);
    }

    public static Dataset create(byte[] data, boolean init) throws IOException {
        Dataset dataSet = new Dataset(new Date(Long.MIN_VALUE), Modes.MEMORY);
        BinaryReader reader = new BinaryReader(data);
        MemoryFactory.load(dataSet, reader, init);
        return dataSet;
    }

    public static Dataset create(String filename) throws IOException {
        File f = new File(filename);
        if (!f.exists() || !f.isFile()) {
            throw new IllegalArgumentException("Could not construct a dataset for MemoryProvider. The path you have provided is either a directory or does not exist: " + filename);
        }
        Date lm = new Date(f.lastModified());
        return MemoryFactory.create(filename, false, lm);
    }

    public static Dataset create(String filename, boolean init) throws IOException {
        File f = new File(filename);
        if (!f.exists() || !f.isFile()) {
            throw new IllegalArgumentException("Could not construct a dataset for MemoryProvider. The path you have provided is either a directory or does not exist: " + filename);
        }
        Date lm = new Date(f.lastModified());
        return MemoryFactory.create(filename, init, lm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dataset create(String filename, boolean init, Date lastModified) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(filename);
        try {
            Dataset dataset = MemoryFactory.create(fileInputStream, init, lastModified);
            return dataset;
        }
        finally {
            fileInputStream.close();
        }
    }

    public static Dataset create(FileInputStream fileInputStream) throws IOException {
        return MemoryFactory.create(fileInputStream, false);
    }

    public static Dataset create(FileInputStream fileInputStream, boolean init) throws IOException {
        return MemoryFactory.create(fileInputStream, init, new Date(Long.MIN_VALUE));
    }

    public static Dataset create(FileInputStream fileInputStream, boolean init, Date lastModified) throws IOException {
        Dataset dataSet = new Dataset(lastModified, Modes.MEMORY);
        BinaryReader reader = new BinaryReader(fileInputStream);
        MemoryFactory.load(dataSet, reader, init);
        return dataSet;
    }

    public static void load(Dataset dataSet, BinaryReader reader, boolean init) throws IOException {
        CommonFactory.loadHeader(dataSet, reader);
        MemoryVariableList<AsciiString> strings = new MemoryVariableList<AsciiString>(dataSet, reader, new AsciiStringFactory());
        MemoryFixedList<Component> components = null;
        switch (dataSet.versionEnum) {
            case PatternV31: {
                components = new MemoryFixedList<Component>(dataSet, reader, new ComponentFactoryV31());
                break;
            }
            case PatternV32: {
                components = new MemoryFixedList<Component>(dataSet, reader, new ComponentFactoryV32());
            }
        }
        MemoryFixedList<Map> maps = new MemoryFixedList<Map>(dataSet, reader, new MapFactory());
        PropertiesList properties = new PropertiesList(dataSet, reader, new PropertyFactory());
        MemoryFixedList<Value> values = new MemoryFixedList<Value>(dataSet, reader, new ValueFactory());
        MemoryVariableList<Profile> profiles = new MemoryVariableList<Profile>(dataSet, reader, new ProfileMemoryFactory());
        MemoryFixedList<Signature> signatures = null;
        MemoryIntegerList signatureNodeOffsets = null;
        MemoryIntegerList nodeRankedSignatureIndexes = null;
        switch (dataSet.versionEnum) {
            case PatternV31: {
                signatures = new MemoryFixedList<Signature>(dataSet, reader, new SignatureFactoryV31(dataSet));
                break;
            }
            case PatternV32: {
                signatures = new MemoryFixedList<Signature>(dataSet, reader, new SignatureFactoryV32(dataSet));
                signatureNodeOffsets = new MemoryIntegerList(reader);
                nodeRankedSignatureIndexes = new MemoryIntegerList(reader);
            }
        }
        MemoryIntegerList rankedSignatureIndexes = new MemoryIntegerList(reader);
        MemoryVariableList<Node> nodes = null;
        switch (dataSet.versionEnum) {
            case PatternV31: {
                nodes = new MemoryVariableList<Node>(dataSet, reader, new NodeMemoryFactoryV31());
                break;
            }
            case PatternV32: {
                nodes = new MemoryVariableList<Node>(dataSet, reader, new NodeMemoryFactoryV32());
            }
        }
        MemoryFixedList<Node> rootNodes = new MemoryFixedList<Node>(dataSet, reader, new RootNodeFactory());
        MemoryFixedList<ProfileOffset> profileOffsets = new MemoryFixedList<ProfileOffset>(dataSet, reader, new ProfileOffsetFactory());
        dataSet.strings = strings;
        dataSet.components = components;
        dataSet.maps = maps;
        dataSet.properties = properties;
        dataSet.values = values;
        dataSet.profiles = profiles;
        dataSet.signatures = signatures;
        dataSet.rankedSignatureIndexes = rankedSignatureIndexes;
        switch (dataSet.versionEnum) {
            case PatternV32: {
                dataSet.signatureNodeOffsets = signatureNodeOffsets;
                dataSet.nodeRankedSignatureIndexes = nodeRankedSignatureIndexes;
            }
        }
        dataSet.nodes = nodes;
        dataSet.rootNodes = rootNodes;
        dataSet.profileOffsets = profileOffsets;
        strings.read(reader);
        components.read(reader);
        maps.read(reader);
        properties.read(reader);
        values.read(reader);
        profiles.read(reader);
        signatures.read(reader);
        switch (dataSet.versionEnum) {
            case PatternV32: {
                signatureNodeOffsets.read(reader);
                nodeRankedSignatureIndexes.read(reader);
            }
        }
        rankedSignatureIndexes.read(reader);
        nodes.read(reader);
        rootNodes.read(reader);
        profileOffsets.read(reader);
        if (init) {
            dataSet.init();
            dataSet.signatureNodeOffsets = null;
            dataSet.nodeRankedSignatureIndexes = null;
            System.gc();
        }
    }
}

