/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.factories;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.entities.Guid;
import fiftyone.mobile.detection.entities.Version;
import fiftyone.mobile.detection.readers.BinaryReader;
import fiftyone.properties.DetectionConstants;
import java.util.Calendar;
import java.util.Date;

public class CommonFactory {
    public static void loadHeader(Dataset dataSet, BinaryReader reader) {
        dataSet.version = new Version(reader.readInt32(), reader.readInt32(), reader.readInt32(), reader.readInt32());
        if (!DetectionConstants.supportedPatternFormatVersions.contains(dataSet.version)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Version mismatch. Data is version ");
            sb.append(dataSet.version);
            sb.append("for ");
            sb.append(DetectionConstants.supportedPatternFormatVersions.toString());
            sb.append("reader");
            throw new IllegalArgumentException(sb.toString());
        }
        dataSet.versionEnum = DetectionConstants.supportedPatternFormatVersions.getEnum(dataSet.version);
        dataSet.tag = new Guid(reader.readBytes(16));
        switch (dataSet.versionEnum) {
            case PatternV32: {
                dataSet.export = new Guid(reader.readBytes(16));
            }
        }
        dataSet.copyrightOffset = reader.readInt32();
        dataSet.age = reader.readInt16();
        dataSet.minUserAgentCount = reader.readInt32();
        dataSet.nameOffset = reader.readInt32();
        dataSet.formatOffset = reader.readInt32();
        dataSet.published = CommonFactory.readDate(reader);
        dataSet.nextUpdate = CommonFactory.readDate(reader);
        dataSet.deviceCombinations = reader.readInt32();
        dataSet.maxUserAgentLength = reader.readInt16();
        dataSet.minUserAgentLength = reader.readInt16();
        dataSet.lowestCharacter = reader.readByte();
        dataSet.highestCharacter = reader.readByte();
        dataSet.maxSignatures = reader.readInt32();
        dataSet.signatureProfilesCount = reader.readInt32();
        dataSet.signatureNodesCount = reader.readInt32();
        dataSet.maxValues = reader.readInt16();
        dataSet.csvBufferLength = reader.readInt32();
        dataSet.jsonBufferLength = reader.readInt32();
        dataSet.xmlBufferLength = reader.readInt32();
        dataSet.maxSignaturesClosest = reader.readInt32();
        if (dataSet.versionEnum == DetectionConstants.FORMAT_VERSIONS.PatternV32) {
            dataSet.maximumRank = reader.readInt32();
        }
    }

    private static Date readDate(BinaryReader reader) {
        short year = reader.readInt16();
        int month = reader.readByte() - 1;
        byte day = reader.readByte();
        Calendar cal = Calendar.getInstance();
        cal.clear();
        cal.set(year, month, day);
        return cal.getTime();
    }
}

