/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities.memory;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.entities.BaseEntity;
import fiftyone.mobile.detection.entities.memory.MemoryBaseList;
import fiftyone.mobile.detection.factories.BaseEntityFactory;
import fiftyone.mobile.detection.readers.BinaryReader;
import fiftyone.mobile.detection.search.SearchBase;
import java.io.IOException;
import java.util.List;

public class MemoryVariableList<T extends BaseEntity>
extends MemoryBaseList<T> {
    private final SearchVariableList search = new SearchVariableList();

    public MemoryVariableList(Dataset dataSet, BinaryReader reader, BaseEntityFactory<T> entityFactory) {
        super(dataSet, reader, entityFactory);
    }

    @Override
    public void read(BinaryReader reader) throws IOException {
        int offset = 0;
        for (int index = 0; index < this.header.getCount(); ++index) {
            BaseEntity entity = (BaseEntity)this.entityFactory.create(this.dataSet, offset, reader);
            this.array.add(entity);
            offset += this.entityFactory.getLength(entity);
        }
    }

    @Override
    public T get(int offset) throws IOException {
        int index = this.search.binarySearch(offset);
        if (index >= 0) {
            return (T)((BaseEntity)this.array.get(index));
        }
        return null;
    }

    private class SearchVariableList
    extends SearchBase<T, Integer, List<T>> {
        private SearchVariableList() {
        }

        @Override
        protected int getCount(List<T> list) {
            return list.size();
        }

        @Override
        protected T getValue(List<T> list, int index) throws IOException {
            return (BaseEntity)list.get(index);
        }

        @Override
        protected int compareTo(T item, Integer key) throws IOException {
            return ((BaseEntity)item).compareTo(key);
        }

        int binarySearch(Integer offset) throws IOException {
            return super.binarySearch(MemoryVariableList.this.array, offset);
        }
    }
}

