/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.entities.Node;
import fiftyone.mobile.detection.entities.Signature;
import fiftyone.mobile.detection.readers.BinaryReader;
import java.io.IOException;
import java.util.List;

public class SignatureV32
extends Signature {
    private volatile List<Integer> nodeOffsets;
    private final int rank;
    private final int firstNodeOffsetIndex;
    private final byte flags;
    private final byte nodeCount;

    public SignatureV32(Dataset dataSet, int index, BinaryReader reader) {
        super(dataSet, index, reader);
        this.nodeCount = reader.readByte();
        this.firstNodeOffsetIndex = reader.readInt32();
        this.rank = reader.readInt32();
        this.flags = reader.readByte();
    }

    @Override
    public int getRank() {
        return this.rank;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Integer> getNodeOffsets() throws IOException {
        List<Integer> localNodeOffsets = this.nodeOffsets;
        if (localNodeOffsets == null) {
            SignatureV32 signatureV32 = this;
            synchronized (signatureV32) {
                localNodeOffsets = this.nodeOffsets;
                if (localNodeOffsets == null) {
                    localNodeOffsets = this.nodeOffsets = this.dataSet.getSignatureNodeOffsets().getRange(this.firstNodeOffsetIndex, this.nodeCount);
                }
            }
        }
        return localNodeOffsets;
    }

    @Override
    protected int getSignatureLength() {
        try {
            Node lastNode = this.dataSet.nodes.get(this.dataSet.signatureNodeOffsets.get(this.nodeCount + this.firstNodeOffsetIndex - 1));
            return lastNode.position + lastNode.getLength() + 1;
        }
        catch (IOException ex) {
            return -1;
        }
    }
}

