/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.entities.BaseEntity;
import fiftyone.mobile.detection.entities.Profile;
import fiftyone.mobile.detection.entities.Property;
import fiftyone.mobile.detection.readers.BinaryReader;
import java.io.IOException;
import java.util.ArrayList;

public abstract class Component
extends BaseEntity
implements Comparable<Component> {
    private final int defaultProfileOffset;
    private final int nameOffset;
    private volatile Profile defaultProfile;
    private volatile Profile[] profiles;
    private volatile Property[] properties;
    private volatile String name;
    private final int componentId;

    public Component(Dataset dataSet, int index, BinaryReader reader) {
        super(dataSet, index);
        this.componentId = reader.readByte();
        this.nameOffset = reader.readInt32();
        this.defaultProfileOffset = reader.readInt32();
    }

    @Override
    public int compareTo(Component other) {
        return this.getComponentId() - other.getComponentId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profile getDefaultProfile() throws IOException {
        Profile localDefaultProfile = this.defaultProfile;
        if (localDefaultProfile == null) {
            Component component = this;
            synchronized (component) {
                localDefaultProfile = this.defaultProfile;
                if (localDefaultProfile == null) {
                    this.defaultProfile = localDefaultProfile = this.getDataSet().getProfiles().get(this.defaultProfileOffset);
                }
            }
        }
        return localDefaultProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profile[] getProfiles() throws IOException {
        Profile[] localProfiles = this.profiles;
        if (localProfiles == null) {
            Component component = this;
            synchronized (component) {
                localProfiles = this.profiles;
                if (localProfiles == null) {
                    localProfiles = this.doGetProfiles();
                    this.profiles = localProfiles;
                }
            }
        }
        return localProfiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Property[] getProperties() throws IOException {
        Property[] localProperties = this.properties;
        if (localProperties == null) {
            Component component = this;
            synchronized (component) {
                localProperties = this.properties;
                if (localProperties == null) {
                    localProperties = this.doGetProperties();
                    this.properties = localProperties;
                }
            }
        }
        return localProperties;
    }

    public void init() throws IOException {
        if (this.name == null) {
            this.name = this.getName();
        }
        if (this.defaultProfile == null) {
            this.defaultProfile = this.getDataSet().getProfiles().get(this.defaultProfileOffset);
        }
        if (this.profiles == null) {
            this.profiles = this.doGetProfiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() throws IOException {
        String localName = this.name;
        if (localName == null) {
            Component component = this;
            synchronized (component) {
                localName = this.name;
                if (localName == null) {
                    this.name = localName = this.getDataSet().strings.get(this.nameOffset).toString();
                }
            }
        }
        return localName;
    }

    private Profile[] doGetProfiles() throws IOException {
        ArrayList<Profile> temp = new ArrayList<Profile>();
        for (Profile profile : this.getDataSet().getProfiles()) {
            if (profile.getComponent().getComponentId() != this.componentId) continue;
            temp.add(profile);
        }
        return temp.toArray(new Profile[temp.size()]);
    }

    private Property[] doGetProperties() throws IOException {
        ArrayList<Property> tempProperties = new ArrayList<Property>();
        for (Property property : this.getDataSet().getProperties()) {
            if (property.getComponent().getComponentId() != this.componentId) continue;
            tempProperties.add(property);
        }
        return tempProperties.toArray(new Property[tempProperties.size()]);
    }

    public int getComponentId() {
        return this.componentId;
    }

    public String toString() {
        try {
            return this.getName();
        }
        catch (IOException e) {
            return "Null";
        }
    }

    public abstract String[] getHttpheaders() throws IOException;

    public boolean equals(Component other) {
        return this.getComponentId() == other.getComponentId();
    }
}

