/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection;

import fiftyone.mobile.detection.BaseScore;
import fiftyone.mobile.detection.MatchState;
import fiftyone.mobile.detection.entities.BaseEntity;
import fiftyone.mobile.detection.entities.Node;
import fiftyone.mobile.detection.entities.Signature;
import java.io.IOException;

class ClosestScore
extends BaseScore {
    ClosestScore() {
    }

    @Override
    protected int getInitialScore(Signature signature, int lastNodeCharacter) throws IOException {
        return Math.abs(lastNodeCharacter + 1 - signature.getLength());
    }

    @Override
    protected int getScore(MatchState state, Node node) throws IOException {
        int score = 0;
        int nodeIndex = node.getCharacters().length - 1;
        int targetIndex = node.position + node.getLength();
        if (targetIndex >= state.getTargetUserAgentArray().length) {
            score = targetIndex - state.getTargetUserAgentArray().length;
            nodeIndex -= score;
            targetIndex = state.getTargetUserAgentArray().length - 1;
        }
        while (nodeIndex >= 0 && score < state.getLowestScore()) {
            int difference = Math.abs(state.getTargetUserAgentArray()[targetIndex] - node.getCharacters()[nodeIndex]);
            if (difference != 0) {
                int newTargetIndex;
                int numericDifference = 0;
                int newNodeIndex = nodeIndex + 1;
                for (newTargetIndex = targetIndex + 1; newNodeIndex < node.getLength() && newTargetIndex < state.getTargetUserAgentArray().length && BaseEntity.getIsNumeric(state.getTargetUserAgentArray()[newTargetIndex]) && BaseEntity.getIsNumeric(node.getCharacters()[newNodeIndex]); ++newNodeIndex, ++newTargetIndex) {
                }
                nodeIndex = newNodeIndex - 1;
                targetIndex = newTargetIndex - 1;
                int characters = 0;
                while (nodeIndex >= 0 && BaseEntity.getIsNumeric(state.getTargetUserAgentArray()[targetIndex]) && BaseEntity.getIsNumeric(node.getCharacters()[nodeIndex])) {
                    --nodeIndex;
                    --targetIndex;
                    ++characters;
                }
                if (characters > 1) {
                    numericDifference = Math.abs(BaseEntity.getNumber(state.getTargetUserAgentArray(), targetIndex + 1, characters) - BaseEntity.getNumber(node.getCharacters(), nodeIndex + 1, characters));
                }
                score = numericDifference != 0 ? (score += numericDifference) : (score += difference * 10);
            }
            --nodeIndex;
            --targetIndex;
        }
        return score;
    }
}

