/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection;

import fiftyone.mobile.detection.AutoUpdateStatus;
import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.IndirectDataset;
import fiftyone.mobile.detection.Utilities;
import fiftyone.mobile.detection.entities.Modes;
import fiftyone.mobile.detection.factories.CommonFactory;
import fiftyone.mobile.detection.factories.StreamFactory;
import fiftyone.mobile.detection.readers.BinaryReader;
import fiftyone.properties.DetectionConstants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import java.util.regex.Matcher;
import java.util.zip.GZIPInputStream;

public class AutoUpdate {
    private static final Semaphore autoUpdateSignal = new Semaphore(1, true);
    private static final int INPUT_BUFFER = 4096;

    public static AutoUpdateStatus update(String licenseKey, String dataFilePath) throws FileNotFoundException, NoSuchAlgorithmException, IllegalArgumentException, Exception {
        return AutoUpdate.update(new String[]{licenseKey}, dataFilePath);
    }

    public static AutoUpdateStatus update(String[] licenseKeys, String binaryFilePath) throws FileNotFoundException, NoSuchAlgorithmException, IllegalArgumentException, Exception {
        if (licenseKeys == null || licenseKeys.length == 0) {
            throw new IllegalArgumentException("At least one valid licence key is required to update device data. See https://51degrees.com/compare-data-options to acquire valid licence keys.");
        }
        String[] validKeys = AutoUpdate.getValidKeys(licenseKeys);
        if (validKeys.length == 0) {
            throw new IllegalArgumentException("The license key(s) provided were invalid. See https://51degrees.com/compare-data-options to acquire valid licence keys.");
        }
        return AutoUpdate.download(validKeys, binaryFilePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dataset getDataSetWithHeaderLoaded(File binaryFile) throws IOException {
        Dataset dataSet = null;
        if (binaryFile.exists()) {
            dataSet = new Dataset(new Date(binaryFile.lastModified()), Modes.FILE);
            FileInputStream fileInputStream = new FileInputStream(binaryFile);
            try {
                BinaryReader reader = new BinaryReader(fileInputStream);
                try {
                    CommonFactory.loadHeader(dataSet, reader);
                }
                finally {
                    reader.close();
                }
            }
            finally {
                fileInputStream.close();
            }
        }
        System.gc();
        return dataSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AutoUpdateStatus download(String[] licenceKeys, String binaryFilePath) throws IOException, InterruptedException, Exception {
        AutoUpdateStatus result = AutoUpdateStatus.AUTO_UPDATE_IN_PROGRESS;
        File binaryFile = new File(binaryFilePath);
        File compressedTempFile = AutoUpdate.getTempFileName(binaryFilePath);
        File uncompressedTempFile = AutoUpdate.getTempFileName(binaryFilePath);
        try {
            autoUpdateSignal.acquire();
            HttpURLConnection client = (HttpURLConnection)AutoUpdate.fullUrl(licenceKeys).openConnection();
            DownloadAttributes attrs = AutoUpdate.downloadFile(binaryFile, compressedTempFile, client);
            client.disconnect();
            result = attrs.status;
            if (result == AutoUpdateStatus.AUTO_UPDATE_IN_PROGRESS) {
                result = AutoUpdate.checkedDownloadedFileMD5(attrs, compressedTempFile);
            }
            if (result == AutoUpdateStatus.AUTO_UPDATE_IN_PROGRESS) {
                result = AutoUpdate.decompress(compressedTempFile, uncompressedTempFile);
            }
            if (result == AutoUpdateStatus.AUTO_UPDATE_IN_PROGRESS) {
                result = AutoUpdate.validateDownloadedFile(binaryFile, uncompressedTempFile);
            }
            if (result == AutoUpdateStatus.AUTO_UPDATE_IN_PROGRESS) {
                result = AutoUpdate.activateDownloadedFile(attrs, binaryFile, uncompressedTempFile);
            }
        }
        finally {
            try {
                if (compressedTempFile.exists()) {
                    compressedTempFile.delete();
                }
                if (uncompressedTempFile.exists()) {
                    uncompressedTempFile.delete();
                }
            }
            finally {
                autoUpdateSignal.release();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DownloadAttributes downloadFile(File binaryFile, File compressedTempFile, HttpURLConnection client) throws IOException {
        DownloadAttributes result;
        block14: {
            if (binaryFile.exists()) {
                client.setIfModifiedSince(binaryFile.lastModified());
            }
            client.setInstanceFollowRedirects(true);
            if (client.getResponseCode() == 200) {
                InputStream inputStream = client.getInputStream();
                try {
                    FileOutputStream outputStream = new FileOutputStream(compressedTempFile);
                    try {
                        AutoUpdate.downloadFile(inputStream, outputStream);
                        result = new DownloadAttributes(client.getHeaderField("Content-MD5"), client.getLastModified());
                        break block14;
                    }
                    finally {
                        outputStream.close();
                    }
                }
                finally {
                    inputStream.close();
                }
            }
            switch (client.getResponseCode()) {
                case 301: 
                case 302: {
                    HttpURLConnection redirect = (HttpURLConnection)new URL(client.getHeaderField("Location")).openConnection();
                    result = AutoUpdate.downloadFile(binaryFile, compressedTempFile, redirect);
                    redirect.disconnect();
                    break;
                }
                case 304: {
                    result = new DownloadAttributes(AutoUpdateStatus.AUTO_UPDATE_NOT_NEEDED);
                    break;
                }
                case 429: {
                    result = new DownloadAttributes(AutoUpdateStatus.AUTO_UPDATE_ERR_429_TOO_MANY_ATTEMPTS);
                    break;
                }
                case 403: {
                    result = new DownloadAttributes(AutoUpdateStatus.AUTO_UPDATE_ERR_403_FORBIDDEN);
                    break;
                }
                default: {
                    result = new DownloadAttributes(AutoUpdateStatus.AUTO_UPDATE_HTTPS_ERR);
                }
            }
        }
        return result;
    }

    private static AutoUpdateStatus checkedDownloadedFileMD5(DownloadAttributes attrs, File compressedTempFile) throws NoSuchAlgorithmException, IOException {
        AutoUpdateStatus status = AutoUpdateStatus.AUTO_UPDATE_IN_PROGRESS;
        String downloadHash = AutoUpdate.getMd5Hash(compressedTempFile);
        if (attrs.md5hash == null || !downloadHash.equals(attrs.md5hash)) {
            status = AutoUpdateStatus.AUTO_UPDATE_ERR_MD5_VALIDATION_FAILED;
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AutoUpdateStatus decompress(File sourcePath, File destinationPath) throws IOException {
        AutoUpdateStatus status = AutoUpdateStatus.AUTO_UPDATE_IN_PROGRESS;
        FileInputStream fis = new FileInputStream(sourcePath);
        try {
            FileOutputStream fos = new FileOutputStream(destinationPath);
            try {
                GZIPInputStream gzis = new GZIPInputStream(fis);
                try {
                    int len;
                    byte[] buffer = new byte[4096];
                    while ((len = gzis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                }
                finally {
                    gzis.close();
                }
            }
            finally {
                fos.close();
            }
        }
        finally {
            fis.close();
        }
        return status;
    }

    private static AutoUpdateStatus validateDownloadedFile(File binaryFile, File decompressedTempFile) throws IOException {
        AutoUpdateStatus status = AutoUpdateStatus.AUTO_UPDATE_IN_PROGRESS;
        if (decompressedTempFile.exists()) {
            DataSetAttributes tempAttrs = new DataSetAttributes(decompressedTempFile);
            if (binaryFile.exists()) {
                DataSetAttributes binaryAttrs = new DataSetAttributes(binaryFile);
                status = binaryAttrs.published != tempAttrs.published || binaryAttrs.propertyCount != tempAttrs.propertyCount ? AutoUpdateStatus.AUTO_UPDATE_IN_PROGRESS : AutoUpdateStatus.AUTO_UPDATE_NOT_NEEDED;
            }
        }
        return status;
    }

    private static AutoUpdateStatus activateDownloadedFile(DownloadAttributes attrs, File binaryFile, File uncompressedTempFile) throws Exception {
        AutoUpdateStatus status = AutoUpdateStatus.AUTO_UPDATE_IN_PROGRESS;
        boolean backedUp = true;
        File tempCopyofCurrentMaster = new File(binaryFile.getAbsolutePath() + ".replacing");
        try {
            if (binaryFile.exists()) {
                backedUp = AutoUpdate.renameTo(binaryFile, tempCopyofCurrentMaster);
            }
            if (backedUp) {
                if (AutoUpdate.renameTo(uncompressedTempFile, binaryFile)) {
                    binaryFile.setLastModified(attrs.lastModified);
                    status = AutoUpdateStatus.AUTO_UPDATE_SUCCESS;
                } else {
                    status = AutoUpdateStatus.AUTO_UPDATE_NEW_FILE_CANT_RENAME;
                }
            } else {
                status = AutoUpdateStatus.AUTO_UPDATE_MASTER_FILE_CANT_RENAME;
            }
        }
        catch (Exception ex) {
            if (!binaryFile.exists() && tempCopyofCurrentMaster.exists()) {
                AutoUpdate.renameTo(tempCopyofCurrentMaster, binaryFile);
            }
            throw ex;
        }
        finally {
            if (tempCopyofCurrentMaster.exists()) {
                tempCopyofCurrentMaster.delete();
            }
        }
        return status;
    }

    private static void downloadFile(InputStream inputStream, FileOutputStream outputStream) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[4096];
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, bytesRead);
        }
    }

    private static String[] getValidKeys(String[] licenseKeys) {
        ArrayList<String> validKeys = new ArrayList<String>();
        for (String key : licenseKeys) {
            Matcher m = DetectionConstants.LICENSE_KEY_VALIDATION_REGEX.matcher(key);
            if (!m.matches()) continue;
            validKeys.add(key);
        }
        return validKeys.toArray(new String[validKeys.size()]);
    }

    public static URL fullUrl(String[] licenseKeys) throws MalformedURLException {
        String[] parameters = new String[]{"LicenseKeys=" + Utilities.joinString("|", licenseKeys), "Download=True", "Type=BinaryV32"};
        String url = String.format("%s?%s", "https://distributor.51degrees.com/api/v2/download", Utilities.joinString("&", parameters));
        return new URL(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getMd5Hash(File fileToCheck) throws FileNotFoundException, NoSuchAlgorithmException, IOException {
        FileInputStream fis = new FileInputStream(fileToCheck);
        try {
            int bytesRead;
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[4096];
            while ((bytesRead = fis.read(buffer)) != -1) {
                md5.update(buffer, 0, bytesRead);
            }
            byte[] md5Bytes = md5.digest();
            StringBuilder hashBuilder = new StringBuilder();
            for (int i = 0; i < md5Bytes.length; ++i) {
                hashBuilder.append(String.format("%02X ", md5Bytes[i]));
            }
            String string = hashBuilder.toString().toLowerCase(Locale.ENGLISH).replaceAll(" ", "");
            return string;
        }
        finally {
            fis.close();
        }
    }

    private static File getTempFileName(String dataFilePath) {
        File dataFile = new File(dataFilePath);
        StringBuilder sb = new StringBuilder();
        sb.append(dataFile.getAbsolutePath());
        sb.append(".");
        sb.append(UUID.randomUUID());
        sb.append(".tmp");
        return new File(sb.toString());
    }

    private static boolean renameTo(File sourceFile, File destFile) {
        boolean result = false;
        int iterations = 0;
        while (sourceFile.exists() && iterations < 10) {
            result = sourceFile.renameTo(destFile);
            if (result) continue;
            System.gc();
            ++iterations;
        }
        return result;
    }

    private static class DataSetAttributes {
        final Date published;
        final int propertyCount;

        DataSetAttributes(File dataFile) throws IOException {
            IndirectDataset dataSet = null;
            try {
                dataSet = StreamFactory.create(dataFile.getAbsolutePath(), false);
                this.published = dataSet.published;
                this.propertyCount = dataSet.properties.size();
            }
            finally {
                if (dataSet != null) {
                    ((Dataset)dataSet).close();
                }
            }
        }
    }

    private static class DownloadAttributes {
        final String md5hash;
        final AutoUpdateStatus status;
        final long lastModified;

        DownloadAttributes(String md5hash, long lastModified) {
            this.md5hash = md5hash;
            this.lastModified = lastModified;
            this.status = AutoUpdateStatus.AUTO_UPDATE_IN_PROGRESS;
        }

        DownloadAttributes(AutoUpdateStatus status) {
            this.status = status;
            this.md5hash = null;
            this.lastModified = 0L;
        }
    }
}

