/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities.stream;

import fiftyone.mobile.detection.readers.BinaryReader;
import fiftyone.mobile.detection.readers.SourceBase;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class Pool
implements Closeable {
    private final ConcurrentLinkedQueue<BinaryReader> readers = new ConcurrentLinkedQueue();
    private final SourceBase source;
    private final AtomicInteger readerCount = new AtomicInteger(0);

    public Pool(SourceBase source) {
        this.source = source;
    }

    public BinaryReader getReader() throws IOException {
        BinaryReader reader = this.readers.poll();
        if (reader == null) {
            this.readerCount.incrementAndGet();
            reader = this.source.createReader();
        }
        return reader;
    }

    public void release(BinaryReader reader) {
        this.readers.add(reader);
    }

    public int getReadersCreated() {
        return this.readerCount.get();
    }

    public int getReadersQueued() {
        return this.readers.size();
    }

    @Override
    public void close() throws IOException {
        while (!this.readers.isEmpty()) {
            BinaryReader reader = this.readers.poll();
            if (reader == null) continue;
            reader.close();
        }
    }
}

