/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.entities.Component;
import fiftyone.mobile.detection.readers.BinaryReader;
import java.io.IOException;
import java.util.ArrayList;

public class ComponentV32
extends Component {
    private final int[] httpHeaderOffsets;
    private volatile String[] httpHeaders = null;

    public ComponentV32(Dataset dataSet, int index, BinaryReader reader) {
        super(dataSet, index, reader);
        this.httpHeaderOffsets = new int[reader.readUInt16()];
        for (int i = 0; i < this.httpHeaderOffsets.length; ++i) {
            this.httpHeaderOffsets[i] = reader.readInt32();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getHttpheaders() throws IOException {
        String[] localHttpHeaders = this.httpHeaders;
        if (localHttpHeaders == null) {
            ComponentV32 componentV32 = this;
            synchronized (componentV32) {
                localHttpHeaders = this.httpHeaders;
                if (localHttpHeaders == null) {
                    ArrayList<String> tempList = new ArrayList<String>();
                    for (int element : this.httpHeaderOffsets) {
                        tempList.add(this.dataSet.strings.get(element).toString());
                    }
                    localHttpHeaders = tempList.toArray(new String[tempList.size()]);
                    this.httpHeaders = localHttpHeaders;
                    tempList.clear();
                }
            }
        }
        return localHttpHeaders;
    }
}

