/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.cache;

public interface ICache<K, V> {
    public long getCacheSize();

    public long getCacheMisses();

    public long getCacheRequests();

    public double getPercentageMisses();

    public V get(K var1);

    public void resetCache();

    public static abstract class Base<K, V>
    implements ICache<K, V> {
        @Override
        public long getCacheSize() {
            return -1L;
        }

        @Override
        public long getCacheMisses() {
            return -1L;
        }

        @Override
        public long getCacheRequests() {
            return -1L;
        }

        @Override
        public double getPercentageMisses() {
            if (this.getCacheRequests() == 0L) {
                return -1.0;
            }
            return this.getCacheMisses() / this.getCacheRequests();
        }

        @Override
        public void resetCache() {
        }
    }
}

