/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.Match;
import fiftyone.mobile.detection.MatchResult;
import fiftyone.mobile.detection.cache.IValueLoader;
import fiftyone.mobile.detection.entities.Node;
import fiftyone.mobile.detection.entities.Profile;
import fiftyone.mobile.detection.entities.Signature;
import fiftyone.properties.MatchMethods;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public class MatchState
extends MatchResult
implements IValueLoader<String, MatchResult> {
    final ArrayList<Node> nodesList = new ArrayList();
    private volatile ArrayList<Profile> explicitProfiles;
    private byte[] targetUserAgentArray;
    int nextCharacterPositionIndex;
    final ArrayList<Signature> signatures = new ArrayList();
    final Match match;

    void setElapsed(long value) {
        this.elapsed = value;
    }

    void setMethod(MatchMethods value) {
        this.method = value;
    }

    public void incrNodesEvaluated() {
        ++this.nodesEvaluated;
    }

    void incrRootNodesEvaluated() {
        ++this.rootNodesEvaluated;
    }

    void setSignature(Signature value) {
        this.signature = value;
    }

    void incrSignaturesCompared(int value) {
        this.signaturesCompared += value;
    }

    void incrSignaturesCompared() {
        ++this.signaturesCompared;
    }

    void incrSignaturesRead(int value) {
        this.signaturesRead += value;
    }

    void incrSignaturesRead() {
        ++this.signaturesRead;
    }

    public void incrStringsRead() {
        ++this.stringsRead;
    }

    void setClosestSignaturesCount(int value) {
        this.closestSignaturesCount = value;
    }

    public void incrLowestScore(int value) {
        this.lowestScore += value;
    }

    public void setLowestScore(int value) {
        this.lowestScore = value;
    }

    void setTargetUserAgent(String value) {
        this.targetUserAgent = value;
    }

    @Override
    Node[] getNodes() {
        Node[] result = new Node[this.nodesList.size()];
        this.nodesList.toArray(result);
        return result;
    }

    public ArrayList<Node> getNodesList() {
        return this.nodesList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Profile> getExplicitProfiles() throws IOException {
        ArrayList<Profile> result = this.explicitProfiles;
        if (result == null) {
            MatchState matchState = this;
            synchronized (matchState) {
                result = this.explicitProfiles;
                if (result == null) {
                    if (this.getSignature() != null) {
                        result = new ArrayList();
                        result.addAll(Arrays.asList(this.getSignature().getProfiles()));
                    } else {
                        result = new ArrayList();
                    }
                    this.explicitProfiles = result;
                }
            }
        }
        return result;
    }

    @Override
    public Profile[] getProfiles() throws IOException {
        Profile[] result = new Profile[this.getExplicitProfiles().size()];
        this.getExplicitProfiles().toArray(result);
        return result;
    }

    public byte[] getTargetUserAgentArray() {
        return this.targetUserAgentArray;
    }

    Dataset getDataSet() {
        return this.match.getDataSet();
    }

    MatchState(Match match) {
        super(match.getDataSet());
        this.match = match;
        this.method = MatchMethods.NONE;
    }

    MatchState(Match match, String targetUserAgent) throws UnsupportedEncodingException {
        this(match);
        this.init(targetUserAgent);
    }

    void reset() {
        this.method = MatchMethods.NONE;
        this.nodesEvaluated = 0;
        this.rootNodesEvaluated = 0;
        this.signaturesCompared = 0;
        this.signaturesRead = 0;
        this.stringsRead = 0;
        this.signature = null;
        this.signatures.clear();
        this.nodesList.clear();
        this.explicitProfiles = null;
    }

    void reset(String targetUserAgent) throws UnsupportedEncodingException {
        this.reset();
        this.init(targetUserAgent);
    }

    final void init(String targetUserAgent) throws UnsupportedEncodingException {
        this.targetUserAgentArray = targetUserAgent != null && targetUserAgent.length() > 0 ? targetUserAgent.getBytes("US-ASCII") : new byte[0];
        this.targetUserAgent = targetUserAgent == null ? "" : targetUserAgent;
        this.resetNextCharacterPositionIndex();
    }

    void resetNextCharacterPositionIndex() {
        this.nextCharacterPositionIndex = Math.min(this.targetUserAgentArray.length - 1, this.getDataSet().rootNodes.size() - 1);
    }

    int insertNode(Node node) {
        int index = ~Collections.binarySearch(this.nodesList, node);
        this.nodesList.add(index, node);
        return index;
    }

    int getIndexOf(Node node) throws IOException {
        byte[] characters = node.getCharacters();
        int finalIndex = characters.length - 1;
        for (int index = 0; index < this.getTargetUserAgentArray().length - characters.length; ++index) {
            int nodeIndex = 0;
            for (int targetIndex = index; nodeIndex < characters.length && targetIndex < this.getTargetUserAgentArray().length && characters[nodeIndex] == this.getTargetUserAgentArray()[targetIndex]; ++nodeIndex, ++targetIndex) {
                if (nodeIndex != finalIndex) continue;
                return index;
            }
        }
        return -1;
    }

    void merge(MatchState other) {
        this.signaturesCompared += other.getSignaturesCompared();
        this.signaturesRead += other.getSignaturesRead();
        this.stringsRead += other.getStringsRead();
        this.rootNodesEvaluated += other.getRootNodesEvaluated();
        this.nodesEvaluated += other.getNodesEvaluated();
        this.elapsed += other.getElapsed();
        this.lowestScore += other.getLowestScore();
        if (other.getMethod().getMatchMethods() > this.method.getMatchMethods()) {
            this.method = other.getMethod();
        }
    }

    @Override
    public MatchResult load(String key) throws IOException {
        this.match.provider.matchNoCache(key, this);
        return new MatchResult(this);
    }
}

