/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.IndirectDataset;
import fiftyone.mobile.detection.MatchState;
import fiftyone.mobile.detection.entities.Node;
import fiftyone.mobile.detection.entities.Profile;
import fiftyone.mobile.detection.entities.Signature;
import fiftyone.properties.MatchMethods;
import java.io.IOException;

public class MatchResult {
    private final Dataset dataset;
    protected long elapsed;
    protected MatchMethods method;
    protected int nodesEvaluated;
    protected int rootNodesEvaluated;
    private Integer signatureIndex;
    protected Signature signature;
    protected int signaturesCompared;
    protected int signaturesRead;
    protected int stringsRead;
    protected int closestSignaturesCount;
    protected int lowestScore;
    protected String targetUserAgent;
    protected Node[] nodes;
    private int[] nodeOffsets;
    protected Profile[] profiles;
    private int[] profileOffsets;

    public long getElapsed() {
        return this.elapsed;
    }

    public MatchMethods getMethod() {
        return this.method;
    }

    public int getNodesEvaluated() {
        return this.nodesEvaluated;
    }

    public int getRootNodesEvaluated() {
        return this.rootNodesEvaluated;
    }

    public Signature getSignature() throws IOException {
        return this.signature != null ? this.signature : (this.signatureIndex != null ? this.dataset.signatures.get(this.signatureIndex) : null);
    }

    public int getSignaturesCompared() {
        return this.signaturesCompared;
    }

    public int getSignaturesRead() {
        return this.signaturesRead;
    }

    public int getStringsRead() {
        return this.stringsRead;
    }

    public int getClosestSignaturesCount() {
        return this.closestSignaturesCount;
    }

    public int getLowestScore() {
        return this.lowestScore;
    }

    public String getTargetUserAgent() {
        return this.targetUserAgent;
    }

    Node[] getNodes() throws IOException {
        Node[] localNodes;
        if (this.nodes == null) {
            localNodes = new Node[this.nodeOffsets.length];
            for (int i = 0; i < this.nodeOffsets.length; ++i) {
                localNodes[i] = this.dataset.nodes.get(this.nodeOffsets[i]);
            }
        } else {
            localNodes = this.nodes;
        }
        return localNodes;
    }

    public Profile[] getProfiles() throws IOException {
        Profile[] localProfiles;
        if (this.profiles == null) {
            localProfiles = new Profile[this.profileOffsets.length];
            for (int i = 0; i < this.profileOffsets.length; ++i) {
                localProfiles[i] = this.dataset.profiles.get(this.profileOffsets[i]);
            }
        } else {
            localProfiles = this.profiles;
        }
        return localProfiles;
    }

    protected MatchResult(Dataset dataset) {
        this.dataset = dataset;
    }

    MatchResult(MatchState source) throws IOException {
        this.dataset = source.getDataSet();
        this.elapsed = source.getElapsed();
        this.method = source.getMethod();
        this.nodesEvaluated = source.getNodesEvaluated();
        this.rootNodesEvaluated = source.getRootNodesEvaluated();
        this.signaturesCompared = source.getSignaturesCompared();
        this.signaturesRead = source.getSignaturesRead();
        this.stringsRead = source.getStringsRead();
        this.closestSignaturesCount = source.getClosestSignaturesCount();
        this.lowestScore = source.getLowestScore();
        this.targetUserAgent = source.getTargetUserAgent();
        if (this.dataset instanceof IndirectDataset) {
            this.signatureIndex = source.getSignature() != null ? Integer.valueOf(source.getSignature().index) : null;
            Profile[] localProfiles = source.getProfiles();
            this.profileOffsets = new int[localProfiles.length];
            for (int i = 0; i < localProfiles.length; ++i) {
                this.profileOffsets[i] = localProfiles[i].index;
            }
            Node[] localNodes = source.getNodes();
            this.nodeOffsets = new int[localNodes.length];
            for (int i = 0; i < localNodes.length; ++i) {
                this.nodeOffsets[i] = localNodes[i].index;
            }
        } else {
            this.signature = source.getSignature();
            this.nodes = source.getNodes();
            this.profiles = (Profile[])source.getProfiles().clone();
        }
    }
}

