/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.DatasetBuilder;
import fiftyone.mobile.detection.cache.ICache;
import fiftyone.mobile.detection.entities.Modes;
import fiftyone.mobile.detection.entities.stream.Pool;
import fiftyone.mobile.detection.readers.SourceBase;
import fiftyone.mobile.detection.readers.SourceFile;
import fiftyone.mobile.detection.readers.SourceMemory;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class IndirectDataset
extends Dataset {
    public final Pool pool;
    protected final SourceBase source;
    private Map<DatasetBuilder.CacheType, ICache> cacheMap = new HashMap<DatasetBuilder.CacheType, ICache>(5);

    public IndirectDataset(String fileName, Date lastModified, Modes mode, boolean isTempFile) throws IOException {
        super(lastModified, mode);
        this.source = new SourceFile(fileName, isTempFile);
        this.pool = new Pool(this.source);
    }

    public IndirectDataset(byte[] data, Modes mode) throws IOException {
        super(new Date(Long.MIN_VALUE), mode);
        this.source = new SourceMemory(data);
        this.pool = new Pool(this.source);
    }

    @Override
    public void close() throws IOException {
        this.pool.close();
        this.source.close();
        super.close();
    }

    public int getReadersCreated() {
        return this.pool.getReadersCreated();
    }

    public int getReadersQueued() {
        return this.pool.getReadersQueued();
    }

    @Override
    public void resetCache() {
        for (ICache cache : this.cacheMap.values()) {
            if (cache == null) continue;
            cache.resetCache();
        }
    }

    public ICache getCache(DatasetBuilder.CacheType cacheType) {
        return this.cacheMap.get((Object)cacheType);
    }

    public void setCacheMap(Map<DatasetBuilder.CacheType, ICache> cacheMap) {
        this.cacheMap = cacheMap;
    }
}

