/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities.stream;

import fiftyone.mobile.detection.entities.stream.TrieSource;
import fiftyone.mobile.detection.readers.TrieReader;
import java.io.Closeable;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingDeque;

public class TriePool
implements Closeable {
    private final Queue<TrieReader> readers = new LinkedBlockingDeque<TrieReader>();
    private final TrieSource source;

    public TriePool(TrieSource source) {
        this.source = source;
    }

    public TrieReader getReader() throws IOException {
        TrieReader reader = this.readers.poll();
        if (reader == null) {
            reader = this.source.createReader();
        }
        return reader;
    }

    public void release(TrieReader reader) {
        this.readers.add(reader);
    }

    @Override
    public void close() {
        this.source.close();
    }
}

