/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities.memory;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.entities.memory.Node;
import fiftyone.mobile.detection.factories.NodeFactoryShared;
import fiftyone.mobile.detection.readers.BinaryReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class NodeV32
extends Node {
    private volatile List<Integer> rankedSignatureIndexes;
    private int nodeRankedSignatureValue;

    public NodeV32(Dataset dataSet, int offset, BinaryReader reader) {
        super(dataSet, offset, reader);
        this.rankedSignatureCount = reader.readUInt16();
        this.children = NodeFactoryShared.readNodeIndexesV32(dataSet, reader, (int)((long)(offset + reader.getPos()) - this.nodeStartStreamPosition), this.childrenCount);
        this.numericChildren = this.readNodeNumericIndexes(dataSet, reader, this.numericChildrenCount);
        if (this.rankedSignatureCount > 0) {
            this.nodeRankedSignatureValue = reader.readInt32();
        }
    }

    @Override
    public void init() throws IOException {
        super.init();
        if (this.rankedSignatureIndexes == null) {
            this.rankedSignatureIndexes = this.getRankedSignatureIndexesAsArray();
        }
    }

    private List<Integer> getRankedSignatureIndexesAsArray() throws IOException {
        List<Integer> rsi = null;
        if (this.rankedSignatureCount == 0) {
            rsi = new ArrayList<Integer>();
        } else if (this.rankedSignatureCount == 1) {
            rsi = new ArrayList();
            rsi.add(this.nodeRankedSignatureValue);
        } else if (this.rankedSignatureCount > 1) {
            rsi = this.dataSet.nodeRankedSignatureIndexes.getRange(this.nodeRankedSignatureValue, this.rankedSignatureCount);
        }
        return rsi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Integer> getRankedSignatureIndexes() throws IOException {
        List<Integer> localRankedSignatureIndexes = this.rankedSignatureIndexes;
        if (localRankedSignatureIndexes == null) {
            NodeV32 nodeV32 = this;
            synchronized (nodeV32) {
                localRankedSignatureIndexes = this.rankedSignatureIndexes;
                if (localRankedSignatureIndexes == null) {
                    this.rankedSignatureIndexes = localRankedSignatureIndexes = this.getRankedSignatureIndexesAsArray();
                }
            }
        }
        return localRankedSignatureIndexes;
    }
}

