/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities.stream;

import fiftyone.mobile.detection.entities.BaseEntity;
import fiftyone.mobile.detection.entities.headers.Header;
import fiftyone.mobile.detection.entities.stream.Dataset;
import fiftyone.mobile.detection.factories.BaseEntityFactory;
import fiftyone.mobile.detection.readers.BinaryReader;
import java.io.IOException;

public abstract class StreamBaseList<T extends BaseEntity> {
    protected final Dataset dataSet;
    protected final Header header;
    final BaseEntityFactory<T> entityFactory;

    protected abstract T createEntity(int var1, BinaryReader var2) throws IOException;

    public StreamBaseList(Dataset dataSet, BinaryReader reader, BaseEntityFactory<T> entityFactory) {
        this.dataSet = dataSet;
        this.header = new Header(reader);
        this.entityFactory = entityFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(int key) throws IOException {
        T item = null;
        BinaryReader reader = null;
        try {
            reader = this.dataSet.pool.getReader();
            item = this.createEntity(key, reader);
        }
        finally {
            if (reader != null) {
                this.dataSet.pool.release(reader);
            }
        }
        return item;
    }

    public int size() {
        return this.header.getCount();
    }
}

