/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities.stream;

import fiftyone.mobile.detection.entities.stream.Dataset;
import fiftyone.mobile.detection.entities.stream.Node;
import fiftyone.mobile.detection.factories.NodeFactoryShared;
import fiftyone.mobile.detection.readers.BinaryReader;
import java.io.IOException;
import java.util.List;

public class NodeV31
extends Node {
    private volatile List<Integer> rankedSignatureIndexes;

    public NodeV31(Dataset dataSet, int offset, BinaryReader reader) throws IOException {
        super(dataSet, offset, reader);
        this.rankedSignatureCount = reader.readInt32();
        this.children = NodeFactoryShared.readNodeIndexesV31(dataSet, reader, (int)((long)(offset + reader.getPos()) - this.nodeStartStreamPosition), this.childrenCount);
        this.numericChildrenPosition = reader.getPos();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Integer> getRankedSignatureIndexes() throws IOException {
        List<Integer> localRankedSignatureIndexes = this.rankedSignatureIndexes;
        if (localRankedSignatureIndexes == null) {
            NodeV31 nodeV31 = this;
            synchronized (nodeV31) {
                localRankedSignatureIndexes = this.rankedSignatureIndexes;
                if (localRankedSignatureIndexes == null) {
                    BinaryReader reader = this.pool.getReader();
                    try {
                        reader.setPos(this.numericChildrenPosition + 6 * this.getNumericChildrenLength());
                        this.rankedSignatureIndexes = localRankedSignatureIndexes = NodeV31.readIntegerList(reader, this.rankedSignatureCount);
                    }
                    finally {
                        this.pool.release(reader);
                    }
                }
            }
        }
        return localRankedSignatureIndexes;
    }
}

