/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.WrappedIOException;
import fiftyone.mobile.detection.entities.BaseEntity;
import fiftyone.mobile.detection.entities.Component;
import fiftyone.mobile.detection.entities.Profile;
import fiftyone.mobile.detection.entities.Property;
import fiftyone.mobile.detection.entities.Signature;
import fiftyone.mobile.detection.readers.BinaryReader;
import fiftyone.mobile.detection.search.SearchArrays;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Value
extends BaseEntity {
    private volatile Integer asInt;
    public static final int RECORD_LENGTH = 14;
    private static final SearchValues valuesIndexSearch = new SearchValues();
    private volatile String name;
    private final int nameIndex;
    private volatile Signature[] signatures;
    private volatile List<Integer> profileIndexes;
    private volatile Property property;
    final int propertyIndex;
    private volatile String description;
    private final int descriptionIndex;
    private volatile URL url;
    private final int urlIndex;
    private volatile Double asNumber;
    private volatile Boolean asBool;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() throws IOException {
        String localName = this.name;
        if (localName == null) {
            Value value = this;
            synchronized (value) {
                localName = this.name;
                if (localName == null) {
                    this.name = localName = this.getDataSet().strings.get(this.nameIndex).toString();
                }
            }
        }
        return localName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Signature[] getSignatures() throws IOException {
        Signature[] localSignatures = this.signatures;
        if (localSignatures == null) {
            Value value = this;
            synchronized (value) {
                localSignatures = this.signatures;
                if (localSignatures == null) {
                    localSignatures = this.doGetSignatures();
                    this.signatures = localSignatures;
                }
            }
        }
        return localSignatures;
    }

    public List<Profile> getProfiles() throws IOException {
        ArrayList<Profile> list = new ArrayList<Profile>();
        for (int profileIndex : this.getProfileIndexes()) {
            list.add(this.dataSet.profiles.get(profileIndex));
        }
        return Collections.unmodifiableList(list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Integer> getProfileIndexes() throws IOException {
        List<Integer> localProfileIndexes = this.profileIndexes;
        if (localProfileIndexes == null) {
            Value value = this;
            synchronized (value) {
                localProfileIndexes = this.profileIndexes;
                if (localProfileIndexes == null) {
                    this.profileIndexes = localProfileIndexes = this.doGetProfileIndexes();
                }
            }
        }
        return localProfileIndexes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setProfileIndexes(List<Integer> profileIndexesToSet) {
        List<Integer> localProfileIndexes = this.profileIndexes;
        if (localProfileIndexes == null) {
            Value value = this;
            synchronized (value) {
                localProfileIndexes = this.profileIndexes;
                if (localProfileIndexes == null) {
                    localProfileIndexes = new ArrayList<Integer>();
                    for (Integer profileIndex : profileIndexesToSet) {
                        localProfileIndexes.add(profileIndex);
                    }
                    this.profileIndexes = localProfileIndexes;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Property getProperty() throws IOException {
        Property localProperty = this.property;
        if (localProperty == null) {
            Value value = this;
            synchronized (value) {
                localProperty = this.property;
                if (localProperty == null) {
                    this.property = localProperty = this.getDataSet().getProperties().get(this.propertyIndex);
                }
            }
        }
        return localProperty;
    }

    public Component getComponent() throws IOException {
        return this.getProperty().getComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescription() throws IOException {
        String localDescription = this.description;
        if (this.descriptionIndex >= 0 && localDescription == null) {
            Value value = this;
            synchronized (value) {
                localDescription = this.description;
                if (localDescription == null) {
                    this.description = localDescription = this.getDataSet().strings.get(this.descriptionIndex).toString();
                }
            }
        }
        return localDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getUrl() throws IOException {
        URL localUrl = this.url;
        if (this.urlIndex >= 0 && localUrl == null) {
            Value value = this;
            synchronized (value) {
                localUrl = this.url;
                if (localUrl == null) {
                    this.url = localUrl = new URL(this.getDataSet().strings.get(this.urlIndex).toString());
                }
            }
        }
        return localUrl;
    }

    public Value(Dataset dataSet, int index, BinaryReader reader) {
        super(dataSet, index);
        this.propertyIndex = reader.readInt16();
        this.nameIndex = reader.readInt32();
        this.descriptionIndex = reader.readInt32();
        this.urlIndex = reader.readInt32();
    }

    public Value(Dataset dataSet, Property property, String value) {
        super(dataSet, -1);
        this.propertyIndex = property.index;
        this.name = value;
        this.nameIndex = -1;
        this.descriptionIndex = -1;
        this.urlIndex = -1;
    }

    public void init() throws IOException {
        this.name = this.getDataSet().strings.get(this.nameIndex).toString();
        this.property = this.getDataSet().getProperties().get(this.propertyIndex);
        if (this.descriptionIndex >= 0) {
            this.description = this.getDataSet().strings.get(this.descriptionIndex).toString();
        }
        if (this.urlIndex >= 0) {
            try {
                this.url = new URL(this.getDataSet().strings.get(this.urlIndex).toString());
            }
            catch (MalformedURLException e) {
                this.url = null;
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.index == ((Value)obj).index;
    }

    public int compareTo(String value) {
        try {
            return this.getName().compareTo(value);
        }
        catch (IOException ex) {
            throw new WrappedIOException(ex.getMessage());
        }
    }

    public int compareTo(Value other) {
        if (this.getDataSet() == other.getDataSet()) {
            return this.getIndex() - other.getIndex();
        }
        try {
            return this.getName().compareTo(other.getName());
        }
        catch (IOException ex) {
            throw new WrappedIOException(ex.getMessage());
        }
    }

    public String toString() {
        try {
            return this.getName();
        }
        catch (IOException e) {
            return super.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double toDouble() throws IOException {
        Double localAsNumber = this.asNumber;
        if (localAsNumber == null) {
            Value value = this;
            synchronized (value) {
                localAsNumber = this.asNumber;
                if (localAsNumber == null) {
                    try {
                        this.asNumber = localAsNumber = Double.valueOf(Double.parseDouble(this.getName()));
                    }
                    catch (NumberFormatException e) {
                        this.asNumber = this != this.getProperty().getDefaultValue() ? (localAsNumber = Double.valueOf(this.getProperty().getDefaultValue().toDouble())) : (localAsNumber = Double.valueOf(0.0));
                    }
                }
            }
        }
        return localAsNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean toBool() throws IOException {
        Boolean localAsBool = this.asBool;
        if (localAsBool == null) {
            Value value = this;
            synchronized (value) {
                localAsBool = this.asBool;
                if (localAsBool == null) {
                    this.asBool = localAsBool = Boolean.valueOf(Boolean.parseBoolean(this.getName()));
                }
            }
        }
        return localAsBool;
    }

    public boolean getIsDefault() throws IOException {
        Value defaultValue = this.property.getDefaultValue();
        if (defaultValue != null) {
            return this.getName().equals(defaultValue.getName());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int toInt() throws IOException {
        Integer localAsInt = this.asInt;
        if (localAsInt == null) {
            Value value = this;
            synchronized (value) {
                localAsInt = this.asInt;
                if (localAsInt == null) {
                    Double d = this.toDouble();
                    this.asInt = localAsInt = Integer.valueOf(d.intValue());
                }
            }
        }
        return localAsInt;
    }

    private List<Integer> doGetProfileIndexes() throws IOException {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Profile profile : this.getComponent().getProfiles()) {
            if (valuesIndexSearch.binarySearch(profile.getValues(), this.getIndex()) < 0) continue;
            list.add(profile.index);
        }
        return list;
    }

    private Signature[] doGetSignatures() throws IOException {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Profile profile : this.getProfiles()) {
            int[] arr$ = profile.getSignatureIndexes();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Integer signatureIndex = arr$[i$];
                int localIndex = Collections.binarySearch(list, signatureIndex);
                if (localIndex >= 0) continue;
                list.add(~localIndex, signatureIndex);
            }
        }
        Signature[] result = new Signature[list.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getDataSet().getSignatures().get((Integer)list.get(i));
        }
        return result;
    }

    int[] toIntArray(List<Integer> list) {
        int[] ret = new int[list.size()];
        int i = 0;
        for (Integer e : list) {
            ret[i++] = e;
        }
        return ret;
    }

    private static class SearchValues
    extends SearchArrays<Value, Integer> {
        private SearchValues() {
        }

        @Override
        public int compareTo(Value item, Integer key) {
            return item.compareTo(key);
        }
    }
}

