/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.SortedList;
import fiftyone.mobile.detection.WrappedIOException;
import fiftyone.mobile.detection.entities.BaseEntity;
import fiftyone.mobile.detection.entities.Node;
import fiftyone.mobile.detection.entities.Profile;
import fiftyone.mobile.detection.entities.Property;
import fiftyone.mobile.detection.entities.Value;
import fiftyone.mobile.detection.entities.Values;
import fiftyone.mobile.detection.readers.BinaryReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public abstract class Signature
extends BaseEntity
implements Comparable<Signature> {
    private final int[] profileOffsets;
    private volatile String deviceId;
    private volatile int length;
    private volatile Node[] nodes;
    private volatile String stringValue;
    private volatile Profile[] profiles;
    private volatile SortedList<Integer, Values> propertyIndexToValues;
    private volatile SortedList<String, Values> propertyNameToValues;

    public Signature(Dataset dataSet, int index, BinaryReader reader) {
        super(dataSet, index);
        List<Integer> list = Signature.readPositiveAndZeroIntegers(reader, dataSet.signatureProfilesCount);
        this.profileOffsets = new int[list.size()];
        Iterator<Integer> iter = list.iterator();
        int i = 0;
        while (iter.hasNext()) {
            this.profileOffsets[i] = iter.next();
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profile[] getProfiles() throws IOException {
        Profile[] localProfiles = this.profiles;
        if (localProfiles == null) {
            Signature signature = this;
            synchronized (signature) {
                localProfiles = this.profiles;
                if (localProfiles == null) {
                    localProfiles = this.getProfiles(this.profileOffsets);
                    this.profiles = localProfiles;
                }
            }
        }
        return localProfiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDeviceId() throws IOException {
        String localDeviceId = this.deviceId;
        if (localDeviceId == null) {
            Signature signature = this;
            synchronized (signature) {
                localDeviceId = this.deviceId;
                if (localDeviceId == null) {
                    this.deviceId = localDeviceId = this.initGetDeviceId();
                }
            }
        }
        return localDeviceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Values getValues(Property property) throws IOException {
        Values localValues = (Values)this.getPropertyIndexToValues().get(property.index);
        if (localValues == null) {
            Signature signature = this;
            synchronized (signature) {
                localValues = (Values)this.getPropertyIndexToValues().get(property.index);
                if (localValues == null) {
                    localValues = this.getPropertyValues(property);
                    this.getPropertyIndexToValues().add(property.index, localValues);
                }
            }
        }
        return localValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Values getValues(String propertyName) throws IOException {
        Values localValues = (Values)this.getPropertyNameToValues().get(propertyName);
        if (localValues == null) {
            Signature signature = this;
            synchronized (signature) {
                localValues = (Values)this.getPropertyNameToValues().get(propertyName);
                if (localValues == null) {
                    Property property = this.dataSet.get(propertyName);
                    if (property != null) {
                        localValues = this.getValues(property);
                    }
                    this.getPropertyNameToValues().add(propertyName, localValues);
                }
            }
        }
        return localValues;
    }

    public Iterator<Value> getValues() throws IOException {
        return new ValueIterator(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLength() throws IOException {
        int localLength = this.length;
        if (localLength == 0) {
            Signature signature = this;
            synchronized (signature) {
                localLength = this.length;
                if (localLength == 0) {
                    this.length = localLength = this.getSignatureLength();
                }
            }
        }
        return localLength;
    }

    protected Node[] doGetNodes() throws IOException {
        Node[] nodesLocal = new Node[this.getNodeOffsets().size()];
        for (int i = 0; i < this.getNodeOffsets().size(); ++i) {
            nodesLocal[i] = this.dataSet.nodes.get(this.getNodeOffsets().get(i));
        }
        return nodesLocal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node[] getNodes() throws IOException {
        Node[] localNodes = this.nodes;
        if (localNodes == null) {
            Signature signature = this;
            synchronized (signature) {
                localNodes = this.nodes;
                if (localNodes == null) {
                    localNodes = this.doGetNodes();
                    this.nodes = localNodes;
                }
            }
        }
        return localNodes;
    }

    protected static List<Integer> readPositiveAndZeroIntegers(BinaryReader reader, int count) {
        reader.list.clear();
        for (int i = 0; i < count; ++i) {
            int profileIndex = reader.readInt32();
            if (profileIndex < 0) continue;
            reader.list.add(profileIndex);
        }
        return reader.list;
    }

    public void init() throws IOException {
        if (this.nodes == null) {
            this.nodes = this.getNodes();
        }
        if (this.profiles == null) {
            this.profiles = this.getProfiles();
        }
        if (this.deviceId == null) {
            this.deviceId = this.getDeviceId();
        }
        if (this.length == 0) {
            this.length = this.getSignatureLength();
        }
    }

    public SortedList<String, List<String>> getPropertyValuesAsStrings() throws IOException {
        SortedList<String, List<String>> list = new SortedList<String, List<String>>();
        while (this.getValues().hasNext()) {
            Value v = this.getValues().next();
            if (!list.containsKey(v.getProperty().getName())) {
                list.add(v.getProperty().getName(), new ArrayList());
            }
            ((List)list.get(v.getProperty().getName())).add(v.getName());
        }
        return list;
    }

    @Override
    public int compareTo(List<Node> nodes) throws IOException {
        int tempLength = Math.min(this.getNodeOffsets().size(), nodes.size());
        for (int i = 0; i < tempLength; ++i) {
            int difference = this.getNodeOffsets().get(i) - nodes.get(i).getIndex();
            if (difference == 0) continue;
            return difference;
        }
        if (this.getNodeOffsets().size() < nodes.size()) {
            return -1;
        }
        if (this.getNodeOffsets().size() > nodes.size()) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compareTo(Signature other) {
        try {
            int tempLength = Math.min(this.getNodeOffsets().size(), other.getNodeOffsets().size());
            for (int i = 0; i < tempLength; ++i) {
                int difference = this.getNodeOffsets().get(i) - other.getNodeOffsets().get(i);
                if (difference == 0) continue;
                return difference;
            }
            if (this.getNodeOffsets().size() < other.getNodeOffsets().size()) {
                return -1;
            }
            if (this.getNodeOffsets().size() > other.getNodeOffsets().size()) {
                return 1;
            }
        }
        catch (IOException ex) {
            throw new WrappedIOException(ex.getMessage());
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String localStringValue = this.stringValue;
        if (localStringValue == null) {
            Signature signature = this;
            synchronized (signature) {
                localStringValue = this.stringValue;
                if (localStringValue == null) {
                    try {
                        byte[] buffer = new byte[this.getLength()];
                        for (Node n : this.getNodes()) {
                            n.addCharacters(buffer);
                        }
                        for (int i = 0; i < buffer.length; ++i) {
                            if (buffer[i] != 0) continue;
                            buffer[i] = 32;
                        }
                        this.stringValue = localStringValue = new String(buffer, "US-ASCII");
                    }
                    catch (IOException ex) {
                        throw new WrappedIOException(ex.getMessage());
                    }
                }
            }
        }
        return localStringValue;
    }

    private Profile[] getProfiles(int[] profileIndexes) throws IOException {
        ArrayList<Profile> prof = new ArrayList<Profile>();
        for (int profileIndex : profileIndexes) {
            prof.add(this.getDataSet().getProfiles().get(profileIndex));
        }
        return prof.toArray(new Profile[prof.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SortedList<Integer, Values> getPropertyIndexToValues() {
        SortedList<Integer, Values> localPropertyIndexToValues = this.propertyIndexToValues;
        if (localPropertyIndexToValues == null) {
            Signature signature = this;
            synchronized (signature) {
                localPropertyIndexToValues = this.propertyIndexToValues;
                if (localPropertyIndexToValues == null) {
                    this.propertyIndexToValues = localPropertyIndexToValues = new SortedList();
                }
            }
        }
        return localPropertyIndexToValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SortedList<String, Values> getPropertyNameToValues() {
        SortedList<String, Values> localPropertyNameToValues = this.propertyNameToValues;
        if (localPropertyNameToValues == null) {
            Signature signature = this;
            synchronized (signature) {
                localPropertyNameToValues = this.propertyNameToValues;
                if (localPropertyNameToValues == null) {
                    this.propertyNameToValues = localPropertyNameToValues = new SortedList();
                }
            }
        }
        return localPropertyNameToValues;
    }

    private Values getPropertyValues(Property property) throws IOException {
        Profile profileForProperty = null;
        for (Profile localProfile : this.profiles) {
            if (property.getComponent().getComponentId() != localProfile.getComponent().getComponentId()) continue;
            profileForProperty = localProfile;
            break;
        }
        return profileForProperty != null ? profileForProperty.getValues(property) : null;
    }

    private String initGetDeviceId() throws IOException {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.getProfiles().length; ++i) {
            builder.append(this.getProfiles()[i].profileId);
            if (i >= this.getProfiles().length - 1) continue;
            builder.append("-");
        }
        return builder.toString();
    }

    private Value[] initGetValues() throws IOException {
        ArrayList<Value> result = new ArrayList<Value>();
        for (Profile profile : this.getProfiles()) {
            result.addAll(Arrays.asList(profile.getValues()));
        }
        return result.toArray(new Value[result.size()]);
    }

    public abstract List<Integer> getNodeOffsets() throws IOException;

    protected abstract int getSignatureLength() throws IOException;

    public abstract int getRank() throws IOException;

    public class ValueIterator
    implements Iterator<Value> {
        private final Signature signature;
        int currentProfile;
        int currentValue;

        public ValueIterator(Signature signature2) {
            this.signature = signature2;
            this.currentProfile = 0;
            this.currentValue = 0;
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.currentProfile < this.signature.getProfiles().length && this.currentValue < this.signature.getProfiles()[this.currentProfile].getValues().length) {
                    return true;
                }
            }
            catch (IOException ex) {
                throw new ArrayIndexOutOfBoundsException("");
            }
            return false;
        }

        @Override
        public Value next() {
            try {
                Value v = this.signature.getProfiles()[this.currentProfile].getValues()[this.currentValue];
                ++this.currentProfile;
                if (this.currentValue >= this.signature.getProfiles()[this.currentProfile].getValues().length) {
                    this.currentValue = 0;
                    ++this.currentProfile;
                }
                return v;
            }
            catch (Exception ex) {
                return null;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

