/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.entities.BaseEntity;
import fiftyone.mobile.detection.entities.Component;
import fiftyone.mobile.detection.entities.Profile;
import fiftyone.mobile.detection.entities.Value;
import fiftyone.mobile.detection.entities.Values;
import fiftyone.mobile.detection.readers.BinaryReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class Property
extends BaseEntity
implements Comparable<Property> {
    public final boolean isList;
    public final boolean isMandatory;
    public final boolean showValues;
    public final boolean show;
    public final boolean isObsolete;
    public final byte displayOrder;
    final int firstValueIndex;
    private volatile String[] maps;
    private final int mapCount;
    private final int firstMapIndex;
    private volatile String javascriptName;
    private volatile String name;
    private final int nameOffset;
    public final PropertyValueType valueType;
    private volatile Value defaultValue;
    private final int defaultValueIndex;
    private volatile Component component;
    private final int componentIndex;
    private volatile Values values;
    private volatile boolean valueProfilesSet = false;
    private volatile String description;
    private final int descriptionOffset;
    private volatile String category;
    private final int categoryOffset;
    private volatile URL url;
    private final int urlOffset;
    private final int lastValueIndex;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getMaps() throws IOException {
        String[] localMaps = this.maps;
        if (localMaps == null) {
            Property property = this;
            synchronized (property) {
                localMaps = this.maps;
                if (localMaps == null) {
                    String[] temp = new String[this.mapCount];
                    for (int i = 0; i < this.mapCount; ++i) {
                        temp[i] = this.dataSet.maps.get(i + this.firstMapIndex).getName();
                    }
                    localMaps = temp;
                    this.maps = temp;
                }
            }
        }
        return localMaps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJavaScriptName() throws IOException {
        String localJavascriptName = this.javascriptName;
        if (localJavascriptName == null) {
            Property property = this;
            synchronized (property) {
                localJavascriptName = this.javascriptName;
                if (localJavascriptName == null) {
                    StringBuilder temp = new StringBuilder();
                    for (char character : this.getName().toCharArray()) {
                        if (!Character.isLetterOrDigit(character)) continue;
                        temp.append(character);
                    }
                    this.javascriptName = localJavascriptName = temp.toString();
                }
            }
        }
        return localJavascriptName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() throws IOException {
        String localName = this.name;
        if (localName == null) {
            Property property = this;
            synchronized (property) {
                localName = this.name;
                if (localName == null) {
                    this.name = localName = this.getDataSet().strings.get(this.nameOffset).toString();
                }
            }
        }
        return localName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value getDefaultValue() throws IOException {
        Value localDefaultValue = this.defaultValue;
        if (localDefaultValue == null && this.defaultValueIndex >= 0) {
            Property property = this;
            synchronized (property) {
                localDefaultValue = this.defaultValue;
                if (localDefaultValue == null) {
                    this.defaultValue = localDefaultValue = this.getDataSet().getValues().get(this.defaultValueIndex);
                }
            }
        }
        return localDefaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getComponent() throws IOException {
        Component localComponent = this.component;
        if (localComponent == null) {
            Property property = this;
            synchronized (property) {
                localComponent = this.component;
                if (localComponent == null) {
                    this.component = localComponent = this.getDataSet().components.get(this.componentIndex);
                }
            }
        }
        return localComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Values getValues() throws IOException {
        Values localValues = this.values;
        if (localValues == null) {
            Property property = this;
            synchronized (property) {
                localValues = this.values;
                if (localValues == null) {
                    this.values = localValues = this.doGetValues();
                }
            }
        }
        return localValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureValueProfilesSet() throws IOException {
        boolean localValueProfilesSet = this.valueProfilesSet;
        if (!localValueProfilesSet) {
            Property property = this;
            synchronized (property) {
                localValueProfilesSet = this.valueProfilesSet;
                if (!localValueProfilesSet) {
                    HashMap valueIndexProfileIndexMap = new HashMap();
                    for (Value value : this.getValues().getAll()) {
                        valueIndexProfileIndexMap.put(value.index, new ArrayList());
                    }
                    for (BaseEntity baseEntity : this.getComponent().getProfiles()) {
                        for (Value value : ((Profile)baseEntity).getValues(this).getAll()) {
                            ((List)valueIndexProfileIndexMap.get(value.index)).add(baseEntity.getIndex());
                        }
                    }
                    Iterator i$ = valueIndexProfileIndexMap.keySet().iterator();
                    while (i$.hasNext()) {
                        int valueIndex = (Integer)i$.next();
                        Value value = this.dataSet.values.get(valueIndex);
                        value.setProfileIndexes((List)valueIndexProfileIndexMap.get(valueIndex));
                    }
                    this.valueProfilesSet = true;
                }
            }
        }
    }

    public boolean isValueProfilesSet() {
        return this.valueProfilesSet;
    }

    public List<Profile> findProfiles(String valueName, List<Profile> filterProfiles) throws IOException {
        ArrayList<Profile> result;
        block4: {
            Value value;
            result = new ArrayList<Profile>();
            this.ensureValueProfilesSet();
            if (valueName == null || (value = this.values.get(valueName)) == null) break block4;
            if (filterProfiles == null) {
                for (Integer profileIndex : value.getProfileIndexes()) {
                    result.add(this.dataSet.profiles.get(profileIndex));
                }
            } else {
                for (Profile profile : filterProfiles) {
                    if (!value.getProfileIndexes().contains(profile.getIndex())) continue;
                    result.add(profile);
                }
            }
        }
        return Collections.unmodifiableList(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescription() throws IOException {
        String localDescription = this.description;
        if (localDescription == null && this.descriptionOffset >= 0) {
            Property property = this;
            synchronized (property) {
                localDescription = this.description;
                if (localDescription == null) {
                    this.description = localDescription = this.getDataSet().strings.get(this.descriptionOffset).toString();
                }
            }
        }
        return localDescription;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCategory() throws IOException {
        String localCategory = this.category;
        if (localCategory == null && this.categoryOffset >= 0) {
            Property property = this;
            synchronized (property) {
                localCategory = this.category;
                if (localCategory == null) {
                    this.category = localCategory = this.getDataSet().strings.get(this.categoryOffset).toString();
                }
            }
        }
        return localCategory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getUrl() throws IOException {
        URL localUrl = this.url;
        if (localUrl == null && this.urlOffset >= 0) {
            Property property = this;
            synchronized (property) {
                localUrl = this.url;
                if (localUrl == null) {
                    try {
                        this.url = localUrl = new URL(this.getDataSet().strings.get(this.urlOffset).toString());
                    }
                    catch (MalformedURLException e) {
                        localUrl = null;
                        this.url = null;
                    }
                }
            }
        }
        return localUrl;
    }

    public int getLastIndexValue() {
        return this.lastValueIndex;
    }

    public Property(Dataset dataSet, int index, BinaryReader reader) throws IOException {
        super(dataSet, index);
        this.componentIndex = reader.readByte();
        this.displayOrder = reader.readByte();
        this.isMandatory = reader.readBoolean();
        this.isList = reader.readBoolean();
        this.showValues = reader.readBoolean();
        this.isObsolete = reader.readBoolean();
        this.show = reader.readBoolean();
        this.valueType = PropertyValueType.create(reader.readByte());
        this.defaultValueIndex = reader.readInt32();
        this.nameOffset = reader.readInt32();
        this.descriptionOffset = reader.readInt32();
        this.categoryOffset = reader.readInt32();
        this.urlOffset = reader.readInt32();
        this.firstValueIndex = reader.readInt32();
        this.lastValueIndex = reader.readInt32();
        this.mapCount = reader.readInt32();
        this.firstMapIndex = reader.readInt32();
        this.valueProfilesSet = false;
    }

    public void init() throws IOException {
        this.getValues();
        this.component = this.getDataSet().getComponents().get(this.componentIndex);
        this.getDescription();
        this.getName();
        this.getCategory();
        this.getUrl();
    }

    private Values doGetValues() throws IOException {
        Value[] tempValues = new Value[this.lastValueIndex - this.firstValueIndex + 1];
        int i = this.firstValueIndex;
        int v = 0;
        while (i <= this.lastValueIndex) {
            tempValues[v] = this.dataSet.getValues().get(i);
            ++i;
            ++v;
        }
        return new Values(this, tempValues);
    }

    @Override
    public int compareTo(Property other) {
        if (this.getDataSet() == other.getDataSet()) {
            return this.getIndex() - other.getIndex();
        }
        try {
            return this.getName().compareTo(other.getName());
        }
        catch (IOException e) {
            return 0;
        }
    }

    public String toString() {
        try {
            return this.getName();
        }
        catch (IOException e) {
            return super.toString();
        }
    }

    public static enum PropertyValueType {
        STRING,
        INT,
        DOUBLE,
        BOOL,
        JAVASCRIPT;


        public static PropertyValueType create(byte b) {
            switch (b) {
                case 0: {
                    return STRING;
                }
                case 1: {
                    return INT;
                }
                case 2: {
                    return DOUBLE;
                }
                case 3: {
                    return BOOL;
                }
                case 4: {
                    return JAVASCRIPT;
                }
            }
            throw new IllegalArgumentException("Unknown property type: " + b);
        }
    }
}

