/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection;

import fiftyone.mobile.detection.Controller;
import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.Match;
import fiftyone.mobile.detection.MatchResult;
import fiftyone.mobile.detection.MatchState;
import fiftyone.mobile.detection.cache.Cache;
import fiftyone.mobile.detection.entities.Component;
import fiftyone.mobile.detection.entities.Profile;
import fiftyone.properties.MatchMethods;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class Provider {
    private Cache<String, MatchResult> userAgentCache = null;
    private final boolean recordDetectionTime;
    private final AtomicLong detectionCount = new AtomicLong(0L);
    private final AtomicLong[] methodCounts;
    public final Dataset dataSet;

    public long getDetectionCount() {
        return this.detectionCount.longValue();
    }

    public long[] getMethodCounts() {
        long[] counts = new long[this.methodCounts.length];
        for (int i = 0; i < this.methodCounts.length; ++i) {
            counts[i] = this.methodCounts[i].get();
        }
        return counts;
    }

    public Provider(Dataset dataSet) {
        this(dataSet, 0);
    }

    public Provider(Dataset dataSet, int cacheSize) {
        this(dataSet, false, cacheSize);
    }

    Provider(Dataset dataSet, boolean recordDetectionTime, int cacheSize) {
        this.recordDetectionTime = recordDetectionTime;
        this.dataSet = dataSet;
        this.methodCounts = new AtomicLong[MatchMethods.values().length];
        this.methodCounts[MatchMethods.CLOSEST.ordinal()] = new AtomicLong();
        this.methodCounts[MatchMethods.NEAREST.ordinal()] = new AtomicLong();
        this.methodCounts[MatchMethods.NUMERIC.ordinal()] = new AtomicLong();
        this.methodCounts[MatchMethods.EXACT.ordinal()] = new AtomicLong();
        this.methodCounts[MatchMethods.NONE.ordinal()] = new AtomicLong();
        this.userAgentCache = cacheSize > 0 ? new Cache(cacheSize) : null;
    }

    public double getPercentageCacheMisses() {
        if (this.userAgentCache != null) {
            return this.userAgentCache.getPercentageMisses();
        }
        return 0.0;
    }

    @Deprecated
    public long getCacheSwitches() {
        return 0L;
    }

    public double getCacheRequests() {
        if (this.userAgentCache != null) {
            return this.userAgentCache.getCacheRequests();
        }
        return 0.0;
    }

    public long getCacheMisses() {
        if (this.userAgentCache != null) {
            return this.userAgentCache.getCacheMisses();
        }
        return -1L;
    }

    public Match createMatch() {
        return new Match(this);
    }

    public Match match(Map<String, String> headers) throws IOException {
        return this.match(headers, this.createMatch());
    }

    public Match match(Map<String, String> headers, Match match) throws IOException {
        match.reset();
        if (headers == null || headers.isEmpty()) {
            Controller.matchDefault(match.state);
        } else {
            ArrayList<String> importantHeaders = new ArrayList<String>();
            for (String datasetHeader : this.dataSet.getHttpHeaders()) {
                if (!headers.containsKey(datasetHeader) || importantHeaders.contains(datasetHeader)) continue;
                importantHeaders.add(datasetHeader);
            }
            if (importantHeaders.size() == 1) {
                this.match(headers.get(importantHeaders.get(0)), match);
            } else {
                Map<String, MatchState> matches = this.matchForHeaders(match, headers, importantHeaders);
                for (Component component : this.dataSet.components) {
                    Profile profile = Provider.getMatchingHeaderProfile(match.state, matches, component);
                    match.state.getExplicitProfiles().add(profile == null ? component.getDefaultProfile() : profile);
                }
                match.state.setSignature(null);
                match.state.setTargetUserAgent(null);
            }
            match.cookie = headers.get("Cookie");
        }
        return match;
    }

    public Match match(String targetUserAgent) throws IOException {
        return this.match(targetUserAgent, this.createMatch());
    }

    public Match match(String targetUserAgent, Match match) throws IOException {
        match.setResult(this.match(targetUserAgent, match.state));
        return match;
    }

    public Match matchForDeviceId(byte[] deviceIdArray) throws IOException {
        return this.matchForDeviceId(deviceIdArray, this.createMatch());
    }

    public Match matchForDeviceId(String deviceId) throws IOException {
        return this.matchForDeviceId(deviceId, this.createMatch());
    }

    public Match matchForDeviceId(ArrayList<Integer> profileIds) throws IOException {
        return this.matchForDeviceId(profileIds, this.createMatch());
    }

    public Match matchForDeviceId(byte[] deviceIdArray, Match match) throws IOException {
        if (deviceIdArray.length == 0) {
            throw new IllegalArgumentException("Byte array containing device Id can not be empty.");
        }
        if (match == null) {
            throw new IllegalArgumentException("Match object can not be null");
        }
        ArrayList<Integer> profileIds = new ArrayList<Integer>();
        for (int i = 0; i < deviceIdArray.length; i += 4) {
            byte[] byteId = Arrays.copyOfRange(deviceIdArray, i, i + 4);
            Integer tempId = new BigInteger(byteId).intValue();
            profileIds.add(tempId);
        }
        return this.matchForDeviceId(profileIds, match);
    }

    public Match matchForDeviceId(String deviceId, Match match) throws IOException {
        if (deviceId.isEmpty()) {
            throw new IllegalArgumentException("String containing device Id can not be empty.");
        }
        if (match == null) {
            throw new IllegalArgumentException("Match object can not be null.");
        }
        String[] profileIdStrings = deviceId.split("-");
        ArrayList<Integer> profileIds = new ArrayList<Integer>();
        for (String profileIdString : profileIdStrings) {
            profileIds.add(Integer.parseInt(profileIdString));
        }
        return this.matchForDeviceId(profileIds, match);
    }

    public Match matchForDeviceId(ArrayList<Integer> profileIds, Match match) throws IOException {
        if (profileIds.isEmpty()) {
            throw new IllegalArgumentException("List of profile Ids can not be empty or null.");
        }
        if (match == null) {
            throw new IllegalArgumentException("Match object can not be null.");
        }
        match.reset();
        for (Integer profileId : profileIds) {
            Profile profile = this.dataSet.findProfile(profileId);
            if (profile == null) continue;
            match.state.getExplicitProfiles().add(profile);
        }
        return match;
    }

    void matchNoCache(String targetUserAgent, MatchState state) throws IOException {
        long startNanoseconds = 0L;
        state.reset(targetUserAgent);
        if (this.recordDetectionTime) {
            startNanoseconds = System.nanoTime();
        }
        Controller.match(state);
        if (this.recordDetectionTime) {
            state.setElapsed(System.nanoTime() - startNanoseconds);
        }
        this.detectionCount.incrementAndGet();
        this.methodCounts[state.getMethod().ordinal()].getAndIncrement();
    }

    private Map<String, MatchState> matchForHeaders(Match match, Map<String, String> headers, ArrayList<String> importantHeaders) throws IOException {
        HashMap<String, MatchState> matches = new HashMap<String, MatchState>();
        for (String string : importantHeaders) {
            matches.put(string, new MatchState(match, headers.get(string)));
        }
        for (Map.Entry entry : matches.entrySet()) {
            this.match(headers.get(entry.getKey()), (MatchState)entry.getValue());
        }
        return matches;
    }

    private MatchResult match(String targetUserAgent, MatchState state) throws IOException {
        MatchResult result;
        if (targetUserAgent == null) {
            targetUserAgent = "";
        }
        if (this.userAgentCache != null) {
            result = this.userAgentCache.get(targetUserAgent, state);
        } else {
            this.matchNoCache(targetUserAgent, state);
            result = state;
        }
        return result;
    }

    private static Profile getMatchingHeaderProfile(MatchState state, Map<String, MatchState> matches, Component component) throws IOException {
        for (String header : component.getHttpheaders()) {
            MatchState headerMatchState = matches.get(header);
            if (headerMatchState == null) continue;
            state.signaturesCompared += headerMatchState.signaturesCompared;
            state.signaturesRead += headerMatchState.signaturesRead;
            state.stringsRead += headerMatchState.stringsRead;
            state.rootNodesEvaluated += headerMatchState.rootNodesEvaluated;
            state.nodesEvaluated += headerMatchState.nodesEvaluated;
            state.elapsed += headerMatchState.elapsed;
            state.lowestScore += headerMatchState.lowestScore;
            if (headerMatchState.method.getMatchMethods() > state.method.getMatchMethods()) {
                state.method = headerMatchState.method;
            }
            if (headerMatchState.getSignature() == null) continue;
            for (Profile profile : headerMatchState.getSignature().getProfiles()) {
                if (!profile.getComponent().equals(component)) continue;
                return profile;
            }
        }
        return null;
    }

    private static Profile processMatchedHeaderProfile(MatchState masterState, MatchState headerState, Component component) throws IOException {
        Profile result = null;
        masterState.merge(headerState);
        Profile[] profiles = headerState.getSignature().getProfiles();
        for (int profileIndex = 0; result == null && profileIndex < profiles.length; ++profileIndex) {
            if (profiles[profileIndex].getComponent() != component) continue;
            result = profiles[profileIndex];
        }
        return result;
    }
}

