/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection;

import fiftyone.mobile.detection.IReadonlyList;
import fiftyone.mobile.detection.ISimpleList;
import fiftyone.mobile.detection.entities.AsciiString;
import fiftyone.mobile.detection.entities.Component;
import fiftyone.mobile.detection.entities.Guid;
import fiftyone.mobile.detection.entities.Map;
import fiftyone.mobile.detection.entities.Modes;
import fiftyone.mobile.detection.entities.Node;
import fiftyone.mobile.detection.entities.Profile;
import fiftyone.mobile.detection.entities.ProfileOffset;
import fiftyone.mobile.detection.entities.Property;
import fiftyone.mobile.detection.entities.Signature;
import fiftyone.mobile.detection.entities.Value;
import fiftyone.mobile.detection.entities.Version;
import fiftyone.mobile.detection.entities.memory.MemoryFixedList;
import fiftyone.mobile.detection.entities.memory.PropertiesList;
import fiftyone.mobile.detection.search.SearchBase;
import fiftyone.mobile.detection.search.SearchResult;
import fiftyone.properties.DetectionConstants;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class Dataset
implements Closeable {
    public boolean FindProfilesInitialiseValueProfiles = false;
    public int age;
    public MemoryFixedList<Component> components;
    public volatile String copyright;
    public int copyrightOffset;
    public int csvBufferLength;
    public int deviceCombinations;
    public Guid export;
    public volatile String format;
    public int formatOffset;
    public byte highestCharacter;
    public int jsonBufferLength;
    public Calendar lastModified = Calendar.getInstance();
    public byte lowestCharacter;
    public MemoryFixedList<Map> maps;
    public int maxSignatures;
    public int maxSignaturesClosest;
    public short maxUserAgentLength;
    public short maxValues;
    public volatile int maximumRank = 0;
    public int minUserAgentCount;
    public short minUserAgentLength;
    public final Modes mode;
    public int nameOffset;
    public Date nextUpdate;
    public IReadonlyList<Node> nodes;
    public ISimpleList nodeRankedSignatureIndexes;
    public IReadonlyList<Profile> profiles;
    public IReadonlyList<ProfileOffset> profileOffsets;
    public PropertiesList properties;
    private Property[] javaScriptProperties = null;
    private Property[] pvoProperties;
    public Date published;
    public ISimpleList rankedSignatureIndexes;
    public IReadonlyList<Node> rootNodes;
    public int signatureNodesCount;
    public ISimpleList signatureNodeOffsets;
    public int signatureProfilesCount;
    public IReadonlyList<Signature> signatures;
    public IReadonlyList<AsciiString> strings;
    public Guid tag;
    public IReadonlyList<Value> values;
    public Version version;
    public DetectionConstants.FORMAT_VERSIONS versionEnum;
    public int xmlBufferLength;
    private boolean disposed = false;
    private volatile Component hardware;
    private volatile Component software;
    private volatile Component browsers;
    private volatile Component crawlers;
    private volatile String name;
    private volatile SearchSignatureByNodes sigantureSearch;
    private volatile SearchProfileOffsetByProfileId profileOffsetSearch;
    private volatile String[] httpHeaders = null;

    public Dataset(Date lastModified, Modes mode) throws IOException {
        this.lastModified.setTime(lastModified);
        this.mode = mode;
    }

    public long getAge() {
        Date now = new Date();
        Date was = new Date(this.age);
        long difference = now.getTime() - was.getTime();
        long diffInSeconds = TimeUnit.MILLISECONDS.toSeconds(difference);
        return diffInSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMaximumRank() {
        int maxRank = this.maximumRank;
        if (maxRank == 0 && this.rankedSignatureIndexes != null) {
            Dataset dataset = this;
            synchronized (dataset) {
                maxRank = this.maximumRank;
                if (maxRank == 0 && this.rankedSignatureIndexes != null) {
                    this.maximumRank = maxRank = this.rankedSignatureIndexes.size();
                }
            }
        }
        return maxRank;
    }

    public boolean getDisposed() {
        return this.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getHardware() throws IOException {
        Component localHardware = this.hardware;
        if (localHardware == null) {
            Dataset dataset = this;
            synchronized (dataset) {
                localHardware = this.hardware;
                if (localHardware == null) {
                    this.hardware = localHardware = this.getComponent("HardwarePlatform");
                }
            }
        }
        return localHardware;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getSoftware() throws IOException {
        Component localSoftware = this.software;
        if (localSoftware == null) {
            Dataset dataset = this;
            synchronized (dataset) {
                localSoftware = this.software;
                if (localSoftware == null) {
                    this.software = localSoftware = this.getComponent("SoftwarePlatform");
                }
            }
        }
        return localSoftware;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getBrowsers() throws IOException {
        Component localBrowsers = this.browsers;
        if (localBrowsers == null) {
            Dataset dataset = this;
            synchronized (dataset) {
                localBrowsers = this.browsers;
                if (localBrowsers == null) {
                    this.browsers = localBrowsers = this.getComponent("BrowserUA");
                }
            }
        }
        return localBrowsers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getCrawlers() throws IOException {
        Component localCrawlers = this.crawlers;
        if (localCrawlers == null) {
            Dataset dataset = this;
            synchronized (dataset) {
                localCrawlers = this.crawlers;
                if (localCrawlers == null) {
                    this.crawlers = localCrawlers = this.getComponent("Crawler");
                }
            }
        }
        return localCrawlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCopyright() throws IOException {
        String localCopyright = this.copyright;
        if (localCopyright == null) {
            Dataset dataset = this;
            synchronized (dataset) {
                localCopyright = this.copyright;
                if (localCopyright == null) {
                    this.copyright = localCopyright = this.strings.get(this.copyrightOffset).toString();
                }
            }
        }
        return localCopyright;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() throws IOException {
        String localName = this.name;
        if (localName == null) {
            Dataset dataset = this;
            synchronized (dataset) {
                localName = this.name;
                if (localName == null) {
                    this.name = localName = this.strings.get(this.nameOffset).toString();
                }
            }
        }
        return localName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFormat() throws IOException {
        String localFormat = this.format;
        if (localFormat == null) {
            Dataset dataset = this;
            synchronized (dataset) {
                localFormat = this.format;
                if (localFormat == null) {
                    this.format = localFormat = this.strings.get(this.formatOffset).toString();
                }
            }
        }
        return localFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SearchSignatureByNodes getSignatureSearch() {
        SearchSignatureByNodes result = this.sigantureSearch;
        if (result == null) {
            Dataset dataset = this;
            synchronized (dataset) {
                result = this.sigantureSearch;
                if (result == null) {
                    this.sigantureSearch = result = new SearchSignatureByNodes(this.signatures);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SearchProfileOffsetByProfileId getProfileOffsetSearch() {
        SearchProfileOffsetByProfileId result = this.profileOffsetSearch;
        if (result == null) {
            Dataset dataset = this;
            synchronized (dataset) {
                result = this.profileOffsetSearch;
                if (result == null) {
                    this.profileOffsetSearch = result = new SearchProfileOffsetByProfileId(this.profileOffsets);
                }
            }
        }
        return result;
    }

    public List<Profile> findProfiles(String propertyName, String valueName, List<Profile> filterProfiles) throws IOException {
        Property property = this.properties.get(propertyName);
        if (property == null) {
            throw new IllegalArgumentException(String.format("Property '%s' does not exist in the '%s' data set. Upgrade to a different data set which includes the property.", propertyName, this.name));
        }
        return this.findProfiles(property, valueName, filterProfiles);
    }

    public List<Profile> findProfiles(Property property, String valueName, List<Profile> filterProfiles) throws IOException {
        return property.findProfiles(valueName, filterProfiles);
    }

    public IReadonlyList<Component> getComponents() {
        return this.components;
    }

    public IReadonlyList<Map> getMaps() {
        return this.maps;
    }

    public IReadonlyList<Property> getProperties() {
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Property[] getJavaScriptProperties() {
        if (this.javaScriptProperties == null) {
            Dataset dataset = this;
            synchronized (dataset) {
                if (this.javaScriptProperties == null) {
                    ArrayList<Property> tempList = new ArrayList<Property>();
                    for (Property property : this.getProperties()) {
                        if (property.valueType != Property.PropertyValueType.JAVASCRIPT) continue;
                        tempList.add(property);
                    }
                    Property[] localJavaScriptProperties = new Property[tempList.size()];
                    tempList.toArray(localJavaScriptProperties);
                    this.javaScriptProperties = localJavaScriptProperties;
                }
            }
        }
        return this.javaScriptProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Property[] getPropertyValueOverrideProperties() throws IOException {
        if (this.pvoProperties == null) {
            Dataset dataset = this;
            synchronized (dataset) {
                if (this.pvoProperties == null) {
                    ArrayList<Property> tempList = new ArrayList<Property>();
                    for (Property property : this.getJavaScriptProperties()) {
                        if (!property.getCategory().equals("Property Value Override")) continue;
                        tempList.add(property);
                    }
                    Property[] localPvoProperties = new Property[tempList.size()];
                    tempList.toArray(localPvoProperties);
                    this.pvoProperties = localPvoProperties;
                }
            }
        }
        return this.pvoProperties;
    }

    public IReadonlyList<Value> getValues() {
        return this.values;
    }

    public IReadonlyList<Signature> getSignatures() {
        return this.signatures;
    }

    public IReadonlyList<Node> getNodes() {
        return this.nodes;
    }

    public IReadonlyList<Profile> getProfiles() {
        return this.profiles;
    }

    public short getMinUserAgentLength() {
        return this.minUserAgentLength;
    }

    public ISimpleList getSignatureNodeOffsets() {
        return this.signatureNodeOffsets;
    }

    public ISimpleList getNodeRankedSignatureIndexes() {
        return this.nodeRankedSignatureIndexes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getHttpHeaders() throws IOException {
        String[] localHttpHeaders = this.httpHeaders;
        if (localHttpHeaders == null) {
            Dataset dataset = this;
            synchronized (dataset) {
                localHttpHeaders = this.httpHeaders;
                if (localHttpHeaders == null) {
                    ArrayList<String> tempList = new ArrayList<String>();
                    for (Component c : this.components) {
                        for (String s : c.getHttpheaders()) {
                            if (tempList.contains(s)) continue;
                            tempList.add(s);
                        }
                    }
                    localHttpHeaders = new String[tempList.size()];
                    tempList.toArray(localHttpHeaders);
                    this.httpHeaders = localHttpHeaders;
                }
            }
        }
        return localHttpHeaders;
    }

    public void init() throws IOException {
        this.name = this.strings.get(this.nameOffset).toString();
        this.format = this.strings.get(this.formatOffset).toString();
        this.copyright = this.strings.get(this.copyrightOffset).toString();
        this.initComponents();
        this.initProperties();
        this.initValues();
        this.initProfiles();
        this.initNodes();
        this.initSignatures();
        this.strings = null;
    }

    public void initSignatures() throws IOException {
        for (Signature signature : this.signatures) {
            signature.init();
        }
    }

    public void initNodes() throws IOException {
        for (Node node : this.nodes) {
            node.init();
        }
    }

    public void initProfiles() throws IOException {
        for (Profile profile : this.profiles) {
            profile.init();
        }
    }

    public void initComponents() throws IOException {
        for (Component component : this.getComponents()) {
            component.init();
        }
    }

    public void initProperties() throws IOException {
        for (Property property : this.getProperties()) {
            property.init();
        }
    }

    public void initValues() throws IOException {
        for (Value value : this.values) {
            value.init();
        }
    }

    public Component getComponent(String componentName) throws IOException {
        for (Component component : this.components) {
            if (!componentName.equals(component.getName())) continue;
            return component;
        }
        return null;
    }

    public Property get(String propertyName) throws IOException {
        return this.properties.get(propertyName);
    }

    public int getProfilesCount() {
        return this.signatureProfilesCount;
    }

    public int getNodesCount() {
        return this.signatureNodesCount;
    }

    public Profile findProfile(int profileId) throws IOException {
        int index = this.getProfileOffsetSearch().binarySearch(profileId);
        return index < 0 ? null : this.profiles.get(this.profileOffsets.get(index).getOffset());
    }

    @Override
    public void close() throws IOException {
        this.disposed = true;
    }

    public ISimpleList getRankedSignatureIndexes() {
        return this.rankedSignatureIndexes;
    }

    @Deprecated
    private static long getSwitches(Object list) {
        return -1L;
    }

    @Deprecated
    public long getRankedSignatureCacheSwitches() {
        return Dataset.getSwitches(this.rankedSignatureIndexes);
    }

    @Deprecated
    public double getPercentageRankedSignatureCacheMisses() {
        return Dataset.getPercentageMisses(this.rankedSignatureIndexes);
    }

    @Deprecated
    public long getSignatureCacheSwitches() {
        return 0L;
    }

    @Deprecated
    public long getNodeCacheSwitches() {
        return Dataset.getSwitches(this.nodes);
    }

    @Deprecated
    public long getStringsCacheSwitches() {
        return Dataset.getSwitches(this.strings);
    }

    @Deprecated
    public long getProfilesCacheSwitches() {
        return Dataset.getSwitches(this.profiles);
    }

    @Deprecated
    public long getValuesCacheSwitches() {
        return Dataset.getSwitches(this.values);
    }

    @Deprecated
    public Property getPropertyByName(String propertyName) throws IOException {
        return this.properties.get(propertyName);
    }

    @Deprecated
    private static double getPercentageMisses(Object list) {
        return -1.0;
    }

    @Deprecated
    public void resetCache() {
    }

    @Deprecated
    public double getPercentageSignatureCacheMisses() {
        return Dataset.getPercentageMisses(this.signatures);
    }

    @Deprecated
    public double getPercentageNodeCacheMisses() {
        return Dataset.getPercentageMisses(this.nodes);
    }

    @Deprecated
    public double getPercentageStringsCacheMisses() {
        return Dataset.getPercentageMisses(this.strings);
    }

    @Deprecated
    public double getPercentageProfilesCacheMisses() {
        return Dataset.getPercentageMisses(this.profiles);
    }

    @Deprecated
    public double getPercentageValuesCacheMisses() {
        return Dataset.getPercentageMisses(this.values);
    }

    private static class SearchProfileOffsetByProfileId
    extends SearchBase<ProfileOffset, Integer, IReadonlyList<ProfileOffset>> {
        private final IReadonlyList<ProfileOffset> profileOffsets;

        SearchProfileOffsetByProfileId(IReadonlyList<ProfileOffset> profileOffsets) {
            this.profileOffsets = profileOffsets;
        }

        @Override
        protected int getCount(IReadonlyList<ProfileOffset> list) {
            return list.size();
        }

        @Override
        protected ProfileOffset getValue(IReadonlyList<ProfileOffset> list, int index) throws IOException {
            return list.get(index);
        }

        @Override
        protected int compareTo(ProfileOffset item, Integer profileId) throws IOException {
            return item.getProfileId() - profileId;
        }

        int binarySearch(Integer profileId) throws IOException {
            return super.binarySearch(this.profileOffsets, profileId);
        }
    }

    static class SearchSignatureByNodes
    extends SearchBase<Signature, List<Node>, IReadonlyList<Signature>> {
        private final IReadonlyList<Signature> signatures;

        SearchSignatureByNodes(IReadonlyList<Signature> signatures) {
            this.signatures = signatures;
        }

        @Override
        protected int getCount(IReadonlyList<Signature> list) {
            return list.size();
        }

        @Override
        protected Signature getValue(IReadonlyList<Signature> list, int index) throws IOException {
            return list.get(index);
        }

        @Override
        protected int compareTo(Signature item, List<Node> nodes) throws IOException {
            return item.compareTo(nodes);
        }

        SearchResult binarySearchResults(List<Node> nodes) throws IOException {
            return super.binarySearchResults(this.signatures, nodes);
        }
    }
}

