/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection;

import fiftyone.mobile.detection.MatchState;
import fiftyone.mobile.detection.RankedSignatureIterator;
import fiftyone.mobile.detection.entities.Node;
import fiftyone.mobile.detection.entities.Signature;
import java.io.IOException;

abstract class BaseScore {
    BaseScore() {
    }

    void evaluateSignatures(MatchState state, RankedSignatureIterator closestSignatures) throws IOException {
        closestSignatures.reset();
        state.setLowestScore(Integer.MAX_VALUE);
        short lastNodeCharacter = state.getNodesList().get((int)(state.getNodesList().size() - 1)).getRoot().position;
        for (int count = 0; closestSignatures.hasNext() && count < state.getDataSet().maxSignatures; ++count) {
            int rankedSignatureIndex = closestSignatures.next();
            int signatureIndex = state.getDataSet().rankedSignatureIndexes.get(rankedSignatureIndex);
            this.evaluateSignature(state, state.getDataSet().signatures.get(signatureIndex), lastNodeCharacter);
        }
    }

    private void evaluateSignature(MatchState state, Signature signature, int lastNodeCharacter) throws IOException {
        state.incrSignaturesCompared();
        int score = this.getScore(state, signature, lastNodeCharacter);
        if (score < state.getLowestScore()) {
            state.setLowestScore(score);
            state.setSignature(signature);
        }
    }

    private int getScore(MatchState state, Signature signature, int lastNodeCharacter) throws IOException {
        int runningScore = this.getInitialScore(signature, lastNodeCharacter);
        int matchNodeIndex = 0;
        int signatureNodeIndex = 0;
        while (signatureNodeIndex < signature.getNodeOffsets().size() && runningScore < state.getLowestScore()) {
            int signatureNodeOffset;
            int matchNodeOffset = matchNodeIndex >= state.getNodesList().size() ? Integer.MAX_VALUE : state.getNodesList().get(matchNodeIndex).getIndex();
            if (matchNodeOffset > (signatureNodeOffset = signature.getNodeOffsets().get(signatureNodeIndex).intValue())) {
                int score = this.getScore(state, state.getDataSet().nodes.get(signature.getNodeOffsets().get(signatureNodeIndex)));
                if (score < 0) {
                    return Integer.MAX_VALUE;
                }
                runningScore += score;
                ++signatureNodeIndex;
                continue;
            }
            if (matchNodeOffset == signatureNodeOffset) {
                ++matchNodeIndex;
                ++signatureNodeIndex;
                continue;
            }
            if (matchNodeOffset >= signatureNodeOffset) continue;
            ++matchNodeIndex;
        }
        return runningScore;
    }

    protected abstract int getScore(MatchState var1, Node var2) throws IOException;

    protected abstract int getInitialScore(Signature var1, int var2) throws IOException;
}

