/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.readers;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;

public class BinaryReader {
    public final List<Integer> list = new ArrayList<Integer>();
    private final ByteBuffer byteBuffer;

    public BinaryReader(byte[] byArray) {
        this.byteBuffer = ByteBuffer.wrap(byArray);
        this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public BinaryReader(FileInputStream fileInputStream) throws IOException {
        FileChannel fileChannel = fileInputStream.getChannel();
        this.byteBuffer = fileInputStream.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
        this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public BinaryReader(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
        this.byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public void setPos(int n) {
        this.byteBuffer.position(n);
    }

    public byte readByte() {
        return this.byteBuffer.get();
    }

    public short readInt16() {
        return this.byteBuffer.getShort();
    }

    public int readInt32() {
        return this.byteBuffer.getInt();
    }

    public boolean readBoolean() {
        return this.byteBuffer.get() != 0;
    }

    public byte[] readBytes(int n) {
        byte[] byArray = new byte[n];
        this.byteBuffer.get(byArray);
        return byArray;
    }
}

