/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.factories;

import fiftyone.mobile.detection.TrieProvider;
import fiftyone.mobile.detection.readers.TrieReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class TrieFactory {
    public static TrieProvider create(String string) throws IOException {
        File file = new File(string);
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            TrieReader trieReader = new TrieReader(fileInputStream.getChannel());
            int n = trieReader.readUShort();
            return new TrieProvider(new String(trieReader.readBytes((int)trieReader.readUInt())), TrieFactory.ReadStrings(trieReader), TrieFactory.ReadProperties(trieReader), TrieFactory.ReadDevices(trieReader), TrieFactory.ReadLookupList(trieReader), trieReader.readLong(), trieReader.getPos(), string);
        }
        return null;
    }

    private static short[] ReadLookupList(TrieReader trieReader) throws IOException {
        short[] sArray = new short[trieReader.readInt()];
        for (int i = 0; i < sArray.length; ++i) {
            sArray[i] = trieReader.readUByte();
        }
        return sArray;
    }

    private static byte[] ReadStrings(TrieReader trieReader) throws IOException {
        return trieReader.readBytes(trieReader.readInt());
    }

    private static byte[] ReadProperties(TrieReader trieReader) throws IOException {
        return trieReader.readBytes(trieReader.readInt());
    }

    private static byte[] ReadDevices(TrieReader trieReader) throws IOException {
        return trieReader.readBytes(trieReader.readInt());
    }
}

