/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.factories;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.entities.AsciiString;
import fiftyone.mobile.detection.entities.Component;
import fiftyone.mobile.detection.entities.Map;
import fiftyone.mobile.detection.entities.Node;
import fiftyone.mobile.detection.entities.Profile;
import fiftyone.mobile.detection.entities.ProfileOffset;
import fiftyone.mobile.detection.entities.Property;
import fiftyone.mobile.detection.entities.RankedSignatureIndex;
import fiftyone.mobile.detection.entities.Signature;
import fiftyone.mobile.detection.entities.Value;
import fiftyone.mobile.detection.entities.memory.MemoryFixedList;
import fiftyone.mobile.detection.entities.memory.MemoryVariableList;
import fiftyone.mobile.detection.factories.AsciiStringFactory;
import fiftyone.mobile.detection.factories.ComponentFactory;
import fiftyone.mobile.detection.factories.MapFactory;
import fiftyone.mobile.detection.factories.NodeFactory;
import fiftyone.mobile.detection.factories.ProfileFactory;
import fiftyone.mobile.detection.factories.ProfileOffsetFactory;
import fiftyone.mobile.detection.factories.PropertyFactory;
import fiftyone.mobile.detection.factories.RankedSignatureIndexFactory;
import fiftyone.mobile.detection.factories.RootNodeFactory;
import fiftyone.mobile.detection.factories.SignatureFactory;
import fiftyone.mobile.detection.factories.ValueFactory;
import fiftyone.mobile.detection.readers.BinaryReader;
import java.io.FileInputStream;
import java.io.IOException;

public final class MemoryFactory {
    public static Dataset create(byte[] byArray) throws IOException {
        return MemoryFactory.create(byArray, false);
    }

    public static Dataset create(byte[] byArray, boolean bl) throws IOException {
        return MemoryFactory.read(new BinaryReader(byArray), bl);
    }

    public static Dataset create(String string) throws IOException {
        return MemoryFactory.create(string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dataset create(String string, boolean bl) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        try {
            Dataset dataset = MemoryFactory.read(new BinaryReader(fileInputStream), bl);
            return dataset;
        }
        finally {
            fileInputStream.close();
        }
    }

    public static Dataset read(BinaryReader binaryReader, boolean bl) throws IOException {
        Dataset dataset = new Dataset(binaryReader);
        MemoryVariableList<AsciiString> memoryVariableList = new MemoryVariableList<AsciiString>(dataset, binaryReader, new AsciiStringFactory());
        MemoryFixedList<Component> memoryFixedList = new MemoryFixedList<Component>(dataset, binaryReader, new ComponentFactory());
        MemoryFixedList<Map> memoryFixedList2 = new MemoryFixedList<Map>(dataset, binaryReader, new MapFactory());
        MemoryFixedList<Property> memoryFixedList3 = new MemoryFixedList<Property>(dataset, binaryReader, new PropertyFactory());
        MemoryFixedList<Value> memoryFixedList4 = new MemoryFixedList<Value>(dataset, binaryReader, new ValueFactory());
        MemoryVariableList<Profile> memoryVariableList2 = new MemoryVariableList<Profile>(dataset, binaryReader, new ProfileFactory());
        MemoryFixedList<Signature> memoryFixedList5 = new MemoryFixedList<Signature>(dataset, binaryReader, new SignatureFactory(dataset));
        MemoryFixedList<RankedSignatureIndex> memoryFixedList6 = new MemoryFixedList<RankedSignatureIndex>(dataset, binaryReader, new RankedSignatureIndexFactory());
        MemoryVariableList<Node> memoryVariableList3 = new MemoryVariableList<Node>(dataset, binaryReader, new NodeFactory());
        MemoryFixedList<Node> memoryFixedList7 = new MemoryFixedList<Node>(dataset, binaryReader, new RootNodeFactory());
        MemoryFixedList<ProfileOffset> memoryFixedList8 = new MemoryFixedList<ProfileOffset>(dataset, binaryReader, new ProfileOffsetFactory());
        dataset.strings = memoryVariableList;
        dataset.components = memoryFixedList;
        dataset.maps = memoryFixedList2;
        dataset.properties = memoryFixedList3;
        dataset.values = memoryFixedList4;
        dataset.profiles = memoryVariableList2;
        dataset.signatures = memoryFixedList5;
        dataset.rankedSignatureIndexes = memoryFixedList6;
        dataset.nodes = memoryVariableList3;
        dataset.rootNodes = memoryFixedList7;
        dataset.profileOffsets = memoryFixedList8;
        memoryVariableList.read(binaryReader);
        memoryFixedList.read(binaryReader);
        memoryFixedList2.read(binaryReader);
        memoryFixedList3.read(binaryReader);
        memoryFixedList4.read(binaryReader);
        memoryVariableList2.read(binaryReader);
        memoryFixedList5.read(binaryReader);
        memoryFixedList6.read(binaryReader);
        memoryVariableList3.read(binaryReader);
        memoryFixedList7.read(binaryReader);
        memoryFixedList8.read(binaryReader);
        if (bl) {
            dataset.init();
            System.gc();
        }
        return dataset;
    }
}

