/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities.stream;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.Disposable;
import fiftyone.mobile.detection.ReadonlyList;
import fiftyone.mobile.detection.entities.BaseEntity;
import fiftyone.mobile.detection.entities.headers.Header;
import fiftyone.mobile.detection.entities.stream.Cache;
import fiftyone.mobile.detection.entities.stream.ICacheList;
import fiftyone.mobile.detection.entities.stream.Pool;
import fiftyone.mobile.detection.entities.stream.Source;
import fiftyone.mobile.detection.factories.BaseEntityFactory;
import fiftyone.mobile.detection.readers.BinaryReader;
import java.io.IOException;

public abstract class BaseList<T extends BaseEntity>
implements ReadonlyList<T>,
ICacheList,
Disposable {
    public final Cache<T> cache;
    final Pool pool;
    protected final Dataset dataSet;
    final Header header;
    final BaseEntityFactory<T> entityFactory;

    protected abstract T createEntity(int var1, BinaryReader var2) throws IOException;

    @Override
    public double getPercentageMisses() {
        return this.cache.getPercentageMisses();
    }

    public int getCount() {
        return this.header.getCount();
    }

    public BaseList(Dataset dataset, BinaryReader binaryReader, Source source, BaseEntityFactory<T> baseEntityFactory) {
        this.dataSet = dataset;
        this.pool = new Pool(source);
        this.header = new Header(binaryReader);
        this.cache = new Cache<T>(baseEntityFactory);
        this.entityFactory = baseEntityFactory;
    }

    @Override
    public T get(int n) throws IOException {
        BaseEntity baseEntity = (BaseEntity)this.cache.itemsActive.get(n);
        if (baseEntity == null) {
            BinaryReader binaryReader = this.pool.getReader();
            baseEntity = this.createEntity(n, binaryReader);
            this.pool.release(binaryReader);
            this.cache.itemsActive.put(n, baseEntity);
            this.cache.misses.incrementAndGet();
        }
        this.cache.addRecent(n, baseEntity);
        this.cache.requests.incrementAndGet();
        return (T)baseEntity;
    }

    @Override
    public void dispose() {
        this.cache.dispose();
        this.pool.dispose();
    }

    @Override
    public int size() {
        return this.header.getCount();
    }
}

