/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.entities.BaseEntity;
import fiftyone.mobile.detection.entities.Component;
import fiftyone.mobile.detection.entities.Value;
import fiftyone.mobile.detection.entities.Values;
import fiftyone.mobile.detection.readers.BinaryReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;

public class Property
extends BaseEntity
implements Comparable<Property> {
    public final boolean isList;
    public final boolean isMandatory;
    public final boolean showValues;
    public final boolean show;
    public final boolean isObsolete;
    public final byte displayOrder;
    final int firstValueIndex;
    private String name;
    private final int nameOffset;
    public final PropertyValueType valueType;
    private Value defaultValue;
    private final int defaultValueIndex;
    private Component component;
    private final int componentIndex;
    private Values values;
    private String description;
    private final int descriptionOffset;
    private String category;
    private final int categoryOffset;
    private URL url;
    private final int urlOffset;
    private int lastValueIndex;
    public final int MapCount;
    public final int FirstMapIndex;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() throws IOException {
        if (this.name == null) {
            Property property = this;
            synchronized (property) {
                if (this.name == null) {
                    this.name = this.getDataSet().strings.get(this.nameOffset).toString();
                }
            }
        }
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Value getDefaultValue() throws IOException {
        if (this.defaultValue == null) {
            Property property = this;
            synchronized (property) {
                if (this.defaultValue == null) {
                    this.defaultValue = this.getDataSet().getValues().get(this.defaultValueIndex);
                }
            }
        }
        return this.defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getComponent() throws IOException {
        if (this.component == null) {
            Property property = this;
            synchronized (property) {
                if (this.component == null) {
                    this.component = this.getDataSet().components.get(this.componentIndex);
                }
            }
        }
        return this.component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Values getValues() throws IOException {
        if (this.values == null) {
            Property property = this;
            synchronized (property) {
                if (this.values == null) {
                    this.values = this.doGetValues();
                }
            }
        }
        return this.values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDescription() throws IOException {
        if (this.description == null && this.descriptionOffset >= 0) {
            Property property = this;
            synchronized (property) {
                if (this.description == null) {
                    this.description = this.getDataSet().strings.get(this.descriptionOffset).toString();
                }
            }
        }
        return this.description;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCategory() throws IOException {
        if (this.category == null && this.categoryOffset >= 0) {
            Property property = this;
            synchronized (property) {
                if (this.category == null) {
                    this.category = this.getDataSet().strings.get(this.categoryOffset).toString();
                }
            }
        }
        return this.category;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL getUrl() throws IOException {
        if (this.url == null && this.urlOffset >= 0) {
            Property property = this;
            synchronized (property) {
                if (this.url == null) {
                    try {
                        this.url = new URL(this.getDataSet().strings.get(this.urlOffset).toString());
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.url = null;
                    }
                }
            }
        }
        return this.url;
    }

    public Property(Dataset dataset, int n, BinaryReader binaryReader) throws IOException {
        super(dataset, n);
        this.componentIndex = binaryReader.readByte();
        this.displayOrder = binaryReader.readByte();
        this.isMandatory = binaryReader.readBoolean();
        this.isList = binaryReader.readBoolean();
        this.showValues = binaryReader.readBoolean();
        this.isObsolete = binaryReader.readBoolean();
        this.show = binaryReader.readBoolean();
        this.valueType = PropertyValueType.create(binaryReader.readByte());
        this.defaultValueIndex = binaryReader.readInt32();
        this.nameOffset = binaryReader.readInt32();
        this.descriptionOffset = binaryReader.readInt32();
        this.categoryOffset = binaryReader.readInt32();
        this.urlOffset = binaryReader.readInt32();
        this.firstValueIndex = binaryReader.readInt32();
        this.lastValueIndex = binaryReader.readInt32();
        this.MapCount = binaryReader.readInt32();
        this.FirstMapIndex = binaryReader.readInt32();
    }

    public void init() throws IOException {
        this.getValues();
        this.component = this.getDataSet().getComponents().get(this.componentIndex);
        this.getDescription();
        this.getName();
        this.getCategory();
        this.getUrl();
    }

    private Values doGetValues() throws IOException {
        ArrayList<Value> arrayList = new ArrayList<Value>(this.lastValueIndex - this.firstValueIndex + 1);
        for (int i = this.firstValueIndex; i <= this.lastValueIndex; ++i) {
            arrayList.add(this.getDataSet().getValues().get(i));
        }
        return new Values(this, arrayList);
    }

    @Override
    public int compareTo(Property property) {
        if (this.getDataSet() == property.getDataSet()) {
            return this.getIndex() - property.getIndex();
        }
        try {
            return this.getName().compareTo(property.getName());
        }
        catch (IOException iOException) {
            return 0;
        }
    }

    public String toString() {
        try {
            return this.getName();
        }
        catch (IOException iOException) {
            return super.toString();
        }
    }

    public static enum PropertyValueType {
        STRING,
        INT,
        DOUBLE,
        BOOL,
        JAVASCRIPT;


        public static PropertyValueType create(byte by) {
            switch (by) {
                case 0: {
                    return STRING;
                }
                case 1: {
                    return INT;
                }
                case 2: {
                    return DOUBLE;
                }
                case 3: {
                    return BOOL;
                }
                case 4: {
                    return JAVASCRIPT;
                }
            }
            throw new RuntimeException("Illegal PropertyValueType: " + by);
        }
    }
}

