/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.entities.BaseEntity;
import fiftyone.mobile.detection.entities.Profile;
import fiftyone.mobile.detection.entities.Property;
import fiftyone.mobile.detection.entities.Value;
import fiftyone.mobile.detection.readers.BinaryReader;
import java.io.IOException;
import java.util.ArrayList;

public class Component
extends BaseEntity
implements Comparable<Component> {
    private final int componentId;
    private String name;
    private final int nameOffset;
    private Property[] properties;
    private Profile[] profiles;
    private Profile defaultProfile;
    private final int defaultProfileOffset;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() throws IOException {
        if (this.name == null) {
            Component component = this;
            synchronized (component) {
                if (this.name == null) {
                    this.name = this.getDataSet().strings.get(this.nameOffset).toString();
                }
            }
        }
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Property[] getProperties() throws IOException {
        if (this.properties == null) {
            Component component = this;
            synchronized (component) {
                if (this.properties == null) {
                    this.properties = this.GetProperties();
                }
            }
        }
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profile[] getProfiles() throws IOException {
        if (this.profiles == null) {
            Component component = this;
            synchronized (component) {
                if (this.profiles == null) {
                    this.profiles = this.GetProfiles();
                }
            }
        }
        return this.profiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profile getDefaultProfile() throws IOException {
        if (this.defaultProfile == null) {
            Component component = this;
            synchronized (component) {
                if (this.defaultProfile == null) {
                    this.defaultProfile = this.getDataSet().getProfiles().get(this.defaultProfileOffset);
                }
            }
        }
        return this.defaultProfile;
    }

    public Component(Dataset dataset, int n, BinaryReader binaryReader) {
        super(dataset, n);
        this.componentId = binaryReader.readByte();
        this.nameOffset = binaryReader.readInt32();
        this.defaultProfileOffset = binaryReader.readInt32();
    }

    public void init() throws IOException {
        this.defaultProfile = this.getDataSet().getProfiles().get(this.defaultProfileOffset);
        this.profiles = this.GetProfiles();
    }

    private Property[] GetProperties() throws IOException {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        for (Property property : this.getDataSet().getProperties()) {
            if (property.getComponent().getComponentId() != this.componentId) continue;
            arrayList.add(property);
        }
        return arrayList.toArray(new Property[arrayList.size()]);
    }

    private Profile[] GetProfiles() throws IOException {
        ArrayList<Profile> arrayList = new ArrayList<Profile>();
        for (Profile profile : this.getDataSet().getProfiles()) {
            for (Value value : profile.getValues()) {
                if (value.getComponent().getComponentId() != this.componentId) continue;
                arrayList.add(profile);
            }
        }
        return arrayList.toArray(new Profile[arrayList.size()]);
    }

    @Override
    public int compareTo(Component component) {
        return this.getComponentId() - component.getComponentId();
    }

    public int getComponentId() {
        return this.componentId;
    }

    public String toString() {
        try {
            return this.getName();
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

