/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection.entities;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.readers.BinaryReader;

public class BaseEntity {
    private final Dataset dataSet;
    private final int offsetOrIndex;

    BaseEntity(Dataset dataset, int n) {
        this.dataSet = dataset;
        this.offsetOrIndex = n;
    }

    protected int binarySearch(BaseEntity[] baseEntityArray, int n) {
        int n2 = 0;
        int n3 = baseEntityArray.length - 1;
        while (n2 <= n3) {
            int n4 = n2 + (n3 - n2) / 2;
            int n5 = baseEntityArray[n4].offsetOrIndex - n;
            if (n5 == 0) {
                return n4;
            }
            if (n5 > 0) {
                n3 = n4 - 1;
                continue;
            }
            n2 = n4 + 1;
        }
        return ~n2;
    }

    static int[] readIntegerArray(BinaryReader binaryReader, int n) {
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = binaryReader.readInt32();
        }
        return nArray;
    }

    protected Dataset getDataSet() {
        return this.dataSet;
    }

    public int getIndex() {
        return this.offsetOrIndex;
    }
}

