/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection;

import fiftyone.mobile.detection.Disposable;
import fiftyone.mobile.detection.entities.stream.TriePool;
import fiftyone.mobile.detection.entities.stream.TrieSource;
import fiftyone.mobile.detection.readers.TrieReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TrieProvider
implements Disposable {
    private static final int SIZE_OF_LONG = 8;
    private static final int SIZE_OF_UINT = 4;
    private static final int SIZE_OF_INT = 4;
    private static final int SIZE_OF_USHORT = 2;
    private static final int SIZE_OF_SHORT = 2;
    private static final int SIZE_OF_UBYTE = 1;
    private static final int SIZE_OF_BYTE = 1;
    public String Copyright;
    private ByteBuffer _Strings;
    private ByteBuffer _properties;
    private ByteBuffer _devices;
    private short[] _lookupList;
    private TriePool _pool;
    private long _nodesOffset;
    private final Map<String, Integer> _propertyIndex = new HashMap<String, Integer>();
    private final List<String> _propertyNames = new ArrayList<String>();
    private int _propertyCount = 0;

    public List<String> PropertyNames() {
        return this._propertyNames;
    }

    public TrieProvider(String string, byte[] byArray, byte[] byArray2, byte[] byArray3, short[] sArray, long l, long l2, String string2) throws FileNotFoundException {
        this.Copyright = string;
        this._Strings = ByteBuffer.wrap(byArray);
        this._properties = ByteBuffer.wrap(byArray2);
        this._devices = ByteBuffer.wrap(byArray3);
        this._lookupList = sArray;
        this._nodesOffset = l2;
        this._Strings.order(ByteOrder.LITTLE_ENDIAN);
        this._properties.order(ByteOrder.LITTLE_ENDIAN);
        this._devices.order(ByteOrder.LITTLE_ENDIAN);
        this._pool = new TriePool(new TrieSource(string2));
        this._propertyCount = byArray2.length / 4;
        this.initPropertyNames();
    }

    public String getUserAgent(String string) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        TrieReader trieReader = this._pool.getReader();
        trieReader.setPos(this._nodesOffset);
        this.getDeviceIndex(trieReader, TrieProvider.getUserAgentByteArray(string), 0, 0, stringBuilder);
        this._pool.release(trieReader);
        return stringBuilder.toString();
    }

    public int getDeviceIndex(String string) throws Exception {
        TrieReader trieReader = this._pool.getReader();
        trieReader.setPos(this._nodesOffset);
        int n = this.getDeviceIndex(trieReader, TrieProvider.getUserAgentByteArray(string), 0, 0);
        this._pool.release(trieReader);
        return n;
    }

    public String getDeviceId(int n) {
        return this.getPropertyValue(n, "Id");
    }

    public String getPropertyValue(int n, String string) {
        return this.getPropertyValue(n, this.getPropertyIndex(string));
    }

    public String getPropertyValue(int n, int n2) {
        int n3 = n * this._propertyCount * 4;
        int n4 = n3 + n2 * 4;
        return this.getStringValue(this._devices.getInt(n4));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPropertyIndex(String string) {
        int n = -1;
        if (this._propertyIndex.containsKey(string)) {
            n = this._propertyIndex.get(string);
        } else {
            Map<String, Integer> map = this._propertyIndex;
            synchronized (map) {
                if (this._propertyIndex.containsKey(string)) {
                    n = this._propertyIndex.get(string);
                } else {
                    for (int i = 0; i < this._propertyCount; ++i) {
                        int n2 = i * 4;
                        if (!this.getStringValue(this._properties.getInt(n2)).equals(string)) continue;
                        n = i;
                        this._propertyIndex.put(string, n);
                        break;
                    }
                }
            }
        }
        return n;
    }

    @Override
    public void dispose() {
        this._pool.dispose();
    }

    private void initPropertyNames() {
        for (int i = 0; i < this._propertyCount; ++i) {
            int n = i * 4;
            String string = this.getStringValue(this._properties.getInt(n));
            if (!this._propertyIndex.containsKey(string)) {
                this._propertyIndex.put(string, i);
            }
            this._propertyNames.add(~Collections.binarySearch(this._propertyNames, string), string);
        }
    }

    private String getStringValue(int n) {
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        byte by = this._Strings.get(n);
        while (by != 0) {
            stringBuilder.append((char)by);
            by = this._Strings.get(n + ++n2);
        }
        return stringBuilder.toString();
    }

    private static byte[] getUserAgentByteArray(String string) {
        byte[] byArray = new byte[string.length() + 1];
        for (int i = 0; i < string.length(); ++i) {
            byArray[i] = string.charAt(i) <= '\u007f' ? (int)string.charAt(i) : 32;
        }
        byArray[byArray.length - 1] = 0;
        return byArray;
    }

    private short getChild(int n, byte by) throws ArrayIndexOutOfBoundsException {
        short s = this._lookupList[n];
        short s2 = this._lookupList[n + 1];
        if (by < s || by > s2) {
            return 127;
        }
        int n2 = n + by - s + 2;
        return this._lookupList[n2];
    }

    public static int sizeOfOffsets(OffsetType offsetType) {
        switch (offsetType) {
            case Bits16: {
                return 2;
            }
            case Bits32: {
                return 4;
            }
        }
        return 8;
    }

    private void setNextNodePosition(TrieReader trieReader, short s, short s2, OffsetType offsetType) throws IOException {
        if (s == 0) {
            long l = trieReader.getPos() + (long)((s2 - 1) * TrieProvider.sizeOfOffsets(offsetType));
            trieReader.setPos(l);
        } else {
            trieReader.setPos(trieReader.getPos() + (long)((s - 1) * TrieProvider.sizeOfOffsets(offsetType)));
            long l = trieReader.getPos();
            switch (offsetType) {
                case Bits16: {
                    l += (long)trieReader.readUShort();
                    break;
                }
                case Bits32: {
                    l += trieReader.readUInt();
                    break;
                }
                default: {
                    l += trieReader.readLong();
                }
            }
            trieReader.setPos(l);
        }
    }

    private int getDeviceIndex(TrieReader trieReader, byte[] byArray, int n, int n2) throws Exception {
        int n3 = trieReader.readInt();
        short s = this.getChild(Math.abs(n3), byArray[n]);
        int n4 = n3 >= 0 ? trieReader.readInt() : n2;
        if (s == 127) {
            return n4;
        }
        byte by = trieReader.readByte();
        if (s >= by) {
            return n4;
        }
        if (by == 1) {
            return this.getDeviceIndex(trieReader, byArray, n + 1, n4);
        }
        OffsetType offsetType = OffsetType.fromByte(trieReader.readByte());
        this.setNextNodePosition(trieReader, s, by, offsetType);
        return this.getDeviceIndex(trieReader, byArray, n + 1, n4);
    }

    private int getDeviceIndex(TrieReader trieReader, byte[] byArray, int n, int n2, StringBuilder stringBuilder) throws Exception {
        stringBuilder.append((char)byArray[n]);
        int n3 = trieReader.readInt();
        short s = this.getChild(Math.abs(n3), byArray[n]);
        int n4 = n3 >= 0 ? trieReader.readInt() : n2;
        if (s == 127) {
            return n4;
        }
        byte by = trieReader.readByte();
        if (s >= by) {
            return n4;
        }
        if (by == 1) {
            return this.getDeviceIndex(trieReader, byArray, n + 1, n4, stringBuilder);
        }
        OffsetType offsetType = OffsetType.fromByte(trieReader.readByte());
        this.setNextNodePosition(trieReader, s, by, offsetType);
        return this.getDeviceIndex(trieReader, byArray, n + 1, n4, stringBuilder);
    }

    public static enum OffsetType {
        Bits16,
        Bits32,
        Bits64;


        public static OffsetType fromByte(byte by) {
            switch (by) {
                case 0: {
                    return Bits16;
                }
                case 1: {
                    return Bits32;
                }
                case 2: {
                    return Bits64;
                }
            }
            return null;
        }
    }
}

