/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection;

import fiftyone.mobile.detection.Cache;
import fiftyone.mobile.detection.Controller;
import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.Match;
import fiftyone.mobile.detection.MatchMethods;
import fiftyone.mobile.detection.SortedList;
import fiftyone.mobile.detection.factories.MemoryFactory;
import fiftyone.mobile.detection.readers.BinaryReader;
import fiftyone.properties.DetectionConstants;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class Provider {
    private Cache<String, Match.MatchState> userAgentCache = null;
    private long detectionCount;
    private final SortedList<MatchMethods, Long> methodCounts;
    public final Dataset dataSet;
    private Controller controller;

    public long getDetectionCount() {
        return this.detectionCount;
    }

    public Provider() throws IOException {
        this(MemoryFactory.read(new BinaryReader(Provider.getEmbeddedByteArray()), false), 0);
    }

    public Provider(int n) throws IOException {
        this(MemoryFactory.read(new BinaryReader(Provider.getEmbeddedByteArray()), false), n);
    }

    private static byte[] getEmbeddedByteArray() throws IOException {
        byte[] byArray = new byte[0x100000];
        InputStream inputStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("51Degrees-Lite.dat");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = inputStream.read(byArray);
        while (n > 0) {
            byteArrayOutputStream.write(byArray, 0, n);
            n = inputStream.read(byArray);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public Provider(Dataset dataset) {
        this(dataset, new Controller(), 0);
    }

    public Provider(Dataset dataset, int n) {
        this(dataset, new Controller(), n);
    }

    Provider(Dataset dataset, Controller controller, int n) {
        this.dataSet = dataset;
        this.controller = controller;
        this.methodCounts = new SortedList();
        this.methodCounts.add(MatchMethods.CLOSEST, 0L);
        this.methodCounts.add(MatchMethods.NEAREST, 0L);
        this.methodCounts.add(MatchMethods.NUMERIC, 0L);
        this.methodCounts.add(MatchMethods.EXACT, 0L);
        this.methodCounts.add(MatchMethods.NONE, 0L);
        this.userAgentCache = n > 0 ? new Cache(n) : null;
    }

    public Match createMatch() {
        return new Match(this.dataSet);
    }

    public Match match(Map<String, String> map) throws IOException {
        return this.match(map, this.createMatch());
    }

    public Match match(Map<String, String> map, Match match) throws IOException {
        Match match2;
        this.match(map.get("User-Agent".toLowerCase()), match);
        String string = Provider.getDeviceUserAgent(map);
        if (string != null && (match2 = this.match(string)) != null) {
            match.signaturesCompared += match2.signaturesCompared;
            match.signaturesRead += match2.signaturesRead;
            match.stringsRead += match2.stringsRead;
            match.rootNodesEvaluated += match2.rootNodesEvaluated;
            match.nodesEvaluated += match2.nodesEvaluated;
            for (int i = 0; i < match.getProfiles().length && i < match2.getProfiles().length; ++i) {
                if (match.getProfiles()[i].getComponent().getComponentId() > 2 || match.getProfiles()[i].getComponent().getComponentId() != match2.getProfiles()[i].getComponent().getComponentId()) continue;
                match.getProfiles()[i] = match2.getProfiles()[i];
            }
            match.setSignature(null);
        }
        return match;
    }

    public Match match(String string) throws IOException {
        return this.match(string, this.createMatch());
    }

    public Match match(String string, Match match) throws IOException {
        if (this.userAgentCache != null && string != null) {
            Match.MatchState matchState = this.userAgentCache.tryGetValue(string);
            if (matchState == null) {
                Match match2 = match = this.matchNoCache(string, match);
                match2.getClass();
                matchState = match2.new Match.MatchState(match);
                this.userAgentCache.setActive(string, matchState);
            } else {
                match.setState(matchState);
            }
            this.userAgentCache.setBackground(string, matchState);
        } else {
            this.matchNoCache(string, match);
        }
        return match;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Match matchNoCache(String string, Match match) throws IOException {
        match.reset(string);
        this.controller.match(match);
        ++this.detectionCount;
        SortedList<MatchMethods, Long> sortedList = this.methodCounts;
        synchronized (sortedList) {
            MatchMethods matchMethods = match.getMethod();
            Long l = (Long)this.methodCounts.get((Object)matchMethods);
            long l2 = l;
            this.methodCounts.put(matchMethods, l2++);
        }
        return match;
    }

    private static String getDeviceUserAgent(Map<String, String> map) {
        for (String string : DetectionConstants.DEVICE_USER_AGENT_HEADERS) {
            if (map.get(string.toLowerCase()) == null) continue;
            return map.get(string.toLowerCase());
        }
        return null;
    }
}

