/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection;

import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.MatchMethods;
import fiftyone.mobile.detection.entities.Node;
import fiftyone.mobile.detection.entities.Profile;
import fiftyone.mobile.detection.entities.Property;
import fiftyone.mobile.detection.entities.Signature;
import fiftyone.mobile.detection.entities.Value;
import fiftyone.mobile.detection.entities.Values;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Match {
    private static final Comparator<Node> nodeComparator = new Comparator<Node>(){

        @Override
        public int compare(Node node, Node node2) {
            int n;
            int n2 = node.getRankedSignatureIndexes().length;
            if (n2 < (n = node2.getRankedSignatureIndexes().length)) {
                return -1;
            }
            if (n2 > n) {
                return 1;
            }
            return 0;
        }
    };
    private final List<Signature> signatures = new ArrayList<Signature>();
    private final List<Node> nodes = new ArrayList<Node>();
    private final Dataset dataSet;
    public int nextCharacterPositionIndex;
    private byte[] targetUserAgentArray;
    private String targetUserAgent;
    private Signature signature;
    public MatchMethods method;
    int signaturesRead;
    int signaturesCompared;
    int rootNodesEvaluated;
    int nodesEvaluated;
    int stringsRead;
    int closestSignaturesCount;
    Profile[] profiles;
    private Integer lowestScore;
    private Map<String, String[]> results;

    public Match(Dataset dataset) {
        this.dataSet = dataset;
    }

    public Match(Dataset dataset, String string) throws UnsupportedEncodingException {
        this.dataSet = dataset;
        this.init(string);
    }

    public byte[] getTargetUserAgentArray() {
        return this.targetUserAgentArray;
    }

    public String getTargetUserAgent() {
        return this.targetUserAgent;
    }

    public Signature getSignature() {
        return this.signature;
    }

    void setSignature(Signature signature) {
        this.signature = signature;
    }

    void reset(String string) throws UnsupportedEncodingException {
        this.nodesEvaluated = 0;
        this.rootNodesEvaluated = 0;
        this.signaturesCompared = 0;
        this.signaturesRead = 0;
        this.stringsRead = 0;
        this.signatures.clear();
        this.nodes.clear();
        this.profiles = null;
        this.setSignature(null);
        this.init(string);
    }

    void setState(MatchState matchState) {
        this.method = matchState.method;
        this.nodesEvaluated = matchState.nodesEvaluated;
        this.profiles = matchState.profiles;
        this.rootNodesEvaluated = matchState.rootNodesEvaluated;
        this.signature = matchState.signature;
        this.signaturesCompared = matchState.signaturesCompared;
        this.signaturesRead = matchState.signaturesRead;
        this.stringsRead = matchState.stringsRead;
        this.closestSignaturesCount = matchState.closestSignaturesCount;
        this.lowestScore = matchState.lowestScore;
        this.targetUserAgent = matchState.targetUserAgent;
        this.targetUserAgentArray = matchState.targetUserAgentArray;
        this.nodes.clear();
        this.nodes.addAll(matchState.nodes);
    }

    private void init(String string) throws UnsupportedEncodingException {
        this.targetUserAgentArray = string != null && string.length() > 0 ? string.getBytes("US-ASCII") : new byte[0];
        this.targetUserAgent = string == null ? "" : string;
        this.resetNextCharacterPositionIndex();
    }

    public int getDifference() {
        return this.getLowestScore() == null ? 0 : this.getLowestScore();
    }

    public MatchMethods getMethod() {
        return this.method;
    }

    public int getSignaturesRead() {
        return this.signaturesRead;
    }

    public int getSignaturesCompared() {
        return this.signaturesCompared;
    }

    public int getRootNodesEvaluated() {
        return this.rootNodesEvaluated;
    }

    public int getNodesEvaluated() {
        return this.nodesEvaluated;
    }

    public int getStringsRead() {
        return this.stringsRead;
    }

    public int getClosestSignaturesCount() {
        return this.closestSignaturesCount;
    }

    public String getDeviceId() throws IOException {
        return this.signature != null ? this.signature.getDeviceId() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Profile[] getProfiles() throws IOException {
        if (this.profiles == null && this.signature != null) {
            Match match = this;
            synchronized (match) {
                if (this.profiles == null) {
                    this.profiles = this.signature.getProfiles();
                }
            }
        }
        return this.profiles;
    }

    public String getUserAgent() {
        return this.signature != null ? this.signature.toString() : null;
    }

    void resetNextCharacterPositionIndex() {
        this.nextCharacterPositionIndex = Math.min(this.targetUserAgentArray.length - 1, this.getDataSet().rootNodes.size() - 1);
    }

    int getExactSignatureIndex() throws IOException {
        int n = 0;
        int n2 = this.getDataSet().getSignatures().size() - 1;
        while (n <= n2) {
            ++this.signaturesRead;
            int n3 = n + (n2 - n) / 2;
            int n4 = this.getDataSet().getSignatures().get(n3).compareTo(this.getNodes());
            if (n4 == 0) {
                return n3;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            n = n3 + 1;
        }
        return -1;
    }

    RankedSignatureIterator getClosestSignatures() throws IOException {
        if (this.nodes.size() == 1) {
            this.closestSignaturesCount = this.nodes.get(0).getRankedSignatureIndexes().length;
            return new RankedSignatureIterator(){
                final int[] rankedSignatureIndexes;
                int index;
                {
                    this.rankedSignatureIndexes = ((Node)Match.this.nodes.get(0)).getRankedSignatureIndexes();
                    this.index = 0;
                }

                @Override
                public boolean hasNext() {
                    return this.index < this.rankedSignatureIndexes.length;
                }

                @Override
                public int next() {
                    int n = this.rankedSignatureIndexes[this.index];
                    ++this.index;
                    return n;
                }

                @Override
                public void reset() {
                    this.index = 0;
                }
            };
        }
        int n = 1;
        int n2 = 2;
        ArrayList<Node> arrayList = new ArrayList<Node>();
        arrayList.addAll(this.nodes);
        Collections.sort(arrayList, nodeComparator);
        Iterator iterator = arrayList.iterator();
        Node node = (Node)iterator.next();
        final PossibleSignatures possibleSignatures = this.buildInitialList(node.getRankedSignatureIndexes());
        while (iterator.hasNext()) {
            node = (Node)iterator.next();
            n = this.getClosestSignaturesForNode(node.getRankedSignatureIndexes(), possibleSignatures, n, n2);
            ++n2;
        }
        PossibleSignature possibleSignature = possibleSignatures.first;
        while (possibleSignature != null) {
            if (possibleSignature.frequency < n) {
                possibleSignatures.remove(possibleSignature);
            }
            possibleSignature = possibleSignature.next;
        }
        this.closestSignaturesCount = possibleSignatures.size;
        return new RankedSignatureIterator(){
            PossibleSignature first;
            PossibleSignature current;
            {
                this.first = possibleSignatures.first;
                this.current = null;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public int next() {
                int n = this.current.rankedSignatureIndex;
                this.current = this.current.next;
                return n;
            }

            @Override
            public void reset() {
                this.current = this.first;
            }
        };
    }

    private int getClosestSignaturesForNode(int[] nArray, PossibleSignatures possibleSignatures, int n, int n2) {
        boolean bl = this.nodes.size() - n2 < n;
        PossibleSignature possibleSignature = possibleSignatures.first;
        int n3 = 0;
        while (n3 < nArray.length && possibleSignature != null) {
            if (possibleSignature.rankedSignatureIndex > nArray[n3]) {
                if (!bl) {
                    possibleSignatures.addBefore(possibleSignature, new PossibleSignature(nArray[n3], 1));
                }
                ++n3;
                continue;
            }
            if (possibleSignature.rankedSignatureIndex < nArray[n3]) {
                if (bl) {
                    PossibleSignature possibleSignature2 = possibleSignature.next;
                    if (possibleSignature.frequency < n) {
                        possibleSignatures.remove(possibleSignature);
                    }
                    possibleSignature = possibleSignature2;
                    continue;
                }
                possibleSignature = possibleSignature.next;
                continue;
            }
            ++possibleSignature.frequency;
            if (possibleSignature.frequency > n) {
                n = possibleSignature.frequency;
            }
            ++n3;
            possibleSignature = possibleSignature.next;
        }
        if (!bl) {
            while (n3 < nArray.length) {
                possibleSignatures.add(new PossibleSignature(nArray[n3], 1));
                ++n3;
            }
        }
        return n;
    }

    private PossibleSignatures buildInitialList(int[] nArray) {
        PossibleSignatures possibleSignatures = new PossibleSignatures();
        for (int n : nArray) {
            possibleSignatures.add(new PossibleSignature(n, 1));
        }
        return possibleSignatures;
    }

    public List<Node> getNodes() {
        return this.nodes;
    }

    public Integer getLowestScore() {
        return this.lowestScore;
    }

    public void setLowestScore(Integer n) {
        this.lowestScore = n;
    }

    public void incrStringsRead() {
        ++this.stringsRead;
    }

    public void incrNodesEvaluated() {
        ++this.nodesEvaluated;
    }

    Dataset getDataSet() {
        return this.dataSet;
    }

    public Values getValues(Property property) throws IOException {
        Values values = null;
        if (property != null) {
            for (Profile profile : this.getProfiles()) {
                if (profile.getComponent().getComponentId() != property.getComponent().getComponentId()) continue;
                values = profile.getValues(property);
                break;
            }
            if (values == null) {
                values = property.getComponent().getDefaultProfile().getValues(property);
            }
        }
        return values;
    }

    public Values getValues(String string) throws IOException {
        return this.getValues(this.dataSet.get(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String[]> getResults() throws IOException {
        if (this.results == null) {
            Match match = this;
            synchronized (match) {
                if (this.results == null) {
                    HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
                    for (Profile profile : this.getProfiles()) {
                        if (profile == null) continue;
                        for (Property property : profile.getProperties()) {
                            Value[] valueArray = profile.getValues();
                            ArrayList<String> arrayList = new ArrayList<String>();
                            for (int i = 0; i < valueArray.length; ++i) {
                                if (valueArray[i].getProperty() != property) continue;
                                arrayList.add(valueArray[i].getName());
                            }
                            hashMap.put(property.getName(), arrayList.toArray(new String[arrayList.size()]));
                        }
                    }
                    hashMap.put("Difference", new String[]{Integer.toString(this.getDifference())});
                    hashMap.put("Nodes", new String[]{this.toString()});
                    hashMap.put("Id", new String[]{this.getDeviceId()});
                    this.results = hashMap;
                }
            }
        }
        return this.results;
    }

    public void cleanTargetUserAgentArray() {
        for (int i = 0; i < this.targetUserAgentArray.length; ++i) {
            if (this.targetUserAgentArray[i] >= this.dataSet.lowestCharacter && this.targetUserAgentArray[i] <= this.dataSet.highestCharacter) continue;
            this.targetUserAgentArray[i] = 63;
        }
    }

    int getIndexOf(Node node) throws IOException {
        byte[] byArray = node.getCharacters();
        int n = byArray.length - 1;
        for (int i = 0; i < this.getTargetUserAgentArray().length - byArray.length; ++i) {
            int n2 = 0;
            for (int j = i; n2 < byArray.length && j < this.getTargetUserAgentArray().length && byArray[n2] == this.getTargetUserAgentArray()[j]; ++n2, ++j) {
                if (n2 != n) continue;
                return i;
            }
        }
        return -1;
    }

    public void updateProfile(int n) throws IOException {
        Profile profile = this.dataSet.findProfile(n);
        if (profile != null) {
            for (int i = 0; i < this.getProfiles().length; ++i) {
                if (this.profiles[i].getComponent().getComponentId() != profile.getComponent().getComponentId()) continue;
                this.profiles[i] = profile;
                break;
            }
        }
    }

    public String toString() {
        if (this.nodes != null && this.nodes.size() > 0) {
            try {
                byte[] byArray = new byte[this.targetUserAgent.length()];
                for (Node node : this.nodes) {
                    node.addCharacters(byArray);
                }
                for (int i = 0; i < byArray.length; ++i) {
                    if (byArray[i] != 0) continue;
                    byArray[i] = 95;
                }
                return new String(byArray, "US-ASCII");
            }
            catch (IOException iOException) {
                return super.toString();
            }
        }
        return super.toString();
    }

    public int insertNode(Node node) {
        int n = ~Collections.binarySearch(this.nodes, node);
        this.nodes.add(n, node);
        return n;
    }

    private class PossibleSignature {
        public final int rankedSignatureIndex;
        public int frequency;
        public PossibleSignature next;
        public PossibleSignature previous;

        PossibleSignature(int n, int n2) {
            this.rankedSignatureIndex = n;
            this.frequency = n2;
        }
    }

    private class PossibleSignatures {
        PossibleSignature first;
        PossibleSignature last;
        int size = 0;

        private PossibleSignatures() {
        }

        void addBefore(PossibleSignature possibleSignature, PossibleSignature possibleSignature2) {
            possibleSignature2.next = possibleSignature;
            possibleSignature2.previous = possibleSignature.previous;
            if (possibleSignature.previous != null) {
                possibleSignature.previous.next = possibleSignature2;
            }
            possibleSignature.previous = possibleSignature2;
            if (possibleSignature == this.first) {
                this.first = possibleSignature2;
            }
            ++this.size;
        }

        void addAfter(PossibleSignature possibleSignature, PossibleSignature possibleSignature2) {
            possibleSignature2.next = possibleSignature.next;
            possibleSignature2.previous = possibleSignature;
            if (possibleSignature.next != null) {
                possibleSignature.next.previous = possibleSignature2;
            }
            possibleSignature.next = possibleSignature2;
            if (possibleSignature == this.last) {
                this.last = possibleSignature2;
            }
            ++this.size;
        }

        void add(PossibleSignature possibleSignature) {
            if (this.last != null) {
                this.addAfter(this.last, possibleSignature);
            } else {
                this.first = possibleSignature;
                this.last = possibleSignature;
                ++this.size;
            }
        }

        void remove(PossibleSignature possibleSignature) {
            if (this.first == possibleSignature) {
                this.first = possibleSignature.next;
            }
            if (this.last == possibleSignature) {
                this.last = possibleSignature.previous;
            }
            if (possibleSignature.previous != null) {
                possibleSignature.previous.next = possibleSignature.next;
            }
            if (possibleSignature.next != null) {
                possibleSignature.next.previous = possibleSignature.previous;
            }
            --this.size;
        }
    }

    public static interface RankedSignatureIterator {
        public void reset();

        public boolean hasNext();

        public int next();
    }

    class MatchState {
        final MatchMethods method;
        final int nodesEvaluated;
        final Profile[] profiles;
        final int rootNodesEvaluated;
        final Signature signature;
        final int signaturesCompared;
        final int signaturesRead;
        final int stringsRead;
        final int lowestScore;
        final String targetUserAgent;
        final byte[] targetUserAgentArray;
        final ArrayList<Node> nodes;
        final int closestSignaturesCount;

        MatchState(Match match2) throws IOException {
            this.method = match2.getMethod();
            this.nodesEvaluated = match2.getNodesEvaluated();
            this.profiles = match2.getProfiles();
            this.rootNodesEvaluated = match2.getRootNodesEvaluated();
            this.signature = match2.getSignature();
            this.signaturesCompared = match2.getSignaturesCompared();
            this.signaturesRead = match2.getSignaturesRead();
            this.stringsRead = match2.getStringsRead();
            this.closestSignaturesCount = match2.getClosestSignaturesCount();
            this.lowestScore = match2.lowestScore;
            this.targetUserAgent = match2.getTargetUserAgent();
            this.targetUserAgentArray = match2.getTargetUserAgentArray();
            this.nodes = new ArrayList(match2.nodes);
        }
    }
}

