/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection;

import fiftyone.mobile.detection.Disposable;
import fiftyone.mobile.detection.ReadonlyList;
import fiftyone.mobile.detection.entities.AsciiString;
import fiftyone.mobile.detection.entities.Component;
import fiftyone.mobile.detection.entities.Guid;
import fiftyone.mobile.detection.entities.Map;
import fiftyone.mobile.detection.entities.Node;
import fiftyone.mobile.detection.entities.Profile;
import fiftyone.mobile.detection.entities.ProfileOffset;
import fiftyone.mobile.detection.entities.Property;
import fiftyone.mobile.detection.entities.RankedSignatureIndex;
import fiftyone.mobile.detection.entities.Signature;
import fiftyone.mobile.detection.entities.Value;
import fiftyone.mobile.detection.entities.Version;
import fiftyone.mobile.detection.entities.stream.ICacheList;
import fiftyone.mobile.detection.readers.BinaryReader;
import fiftyone.properties.DetectionConstants;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;

public class Dataset
implements Disposable {
    private boolean disposed = false;
    public final Date published;
    public final Date nextUpdate;
    public final int minUserAgentCount;
    public final Version version;
    public final short maxUserAgentLength;
    private final short minUserAgentLength;
    public final byte lowestCharacter;
    public final byte highestCharacter;
    public final int deviceCombinations;
    public final int maxSignatures;
    public final short maxValues;
    public final int csvBufferLength;
    public final int jsonBufferLength;
    public final int xmlBufferLength;
    public final int maxSignaturesClosest;
    public final Guid guid;
    public final int age;
    private Component hardware;
    private Component software;
    private Component browsers;
    private Component crawlers;
    protected String copyright;
    protected final int copyrightOffset;
    protected final int nameOffset;
    private String name;
    protected final int formatOffset;
    protected String format;
    public ReadonlyList<Component> components;
    public ReadonlyList<Map> maps;
    public ReadonlyList<Property> properties;
    public ReadonlyList<Value> values;
    public ReadonlyList<Signature> signatures;
    public ReadonlyList<RankedSignatureIndex> rankedSignatureIndexes;
    public ReadonlyList<Profile> profiles;
    public ReadonlyList<Node> nodes;
    public ReadonlyList<Node> rootNodes;
    public ReadonlyList<ProfileOffset> profileOffsets;
    public ReadonlyList<AsciiString> strings;
    private int signatureProfilesCount;
    private int signatureNodesCount;

    public double getPercentageSignatureCacheMisses() {
        if (this.signatures instanceof ICacheList) {
            return ((ICacheList)((Object)this.signatures)).getPercentageMisses();
        }
        return 0.0;
    }

    public double getPercentageNodeCacheMisses() {
        if (this.nodes instanceof ICacheList) {
            return ((ICacheList)((Object)this.nodes)).getPercentageMisses();
        }
        return 0.0;
    }

    public double getPercentageStringsCacheMisses() {
        if (this.strings instanceof ICacheList) {
            return ((ICacheList)((Object)this.strings)).getPercentageMisses();
        }
        return 0.0;
    }

    public double getPercentageProfilesCacheMisses() {
        if (this.profiles instanceof ICacheList) {
            return ((ICacheList)((Object)this.profiles)).getPercentageMisses();
        }
        return 0.0;
    }

    public double getPercentageValuesCacheMisses() {
        if (this.values instanceof ICacheList) {
            return ((ICacheList)((Object)this.values)).getPercentageMisses();
        }
        return 0.0;
    }

    public boolean getDisposed() {
        return this.disposed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getHardware() throws IOException {
        if (this.hardware == null) {
            Dataset dataset = this;
            synchronized (dataset) {
                if (this.hardware == null) {
                    this.hardware = this.getComponent("HardwarePlatform");
                }
            }
        }
        return this.hardware;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getSoftware() throws IOException {
        if (this.software == null) {
            Dataset dataset = this;
            synchronized (dataset) {
                if (this.software == null) {
                    this.software = this.getComponent("SoftwarePlatform");
                }
            }
        }
        return this.software;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getBrowsers() throws IOException {
        if (this.browsers == null) {
            Dataset dataset = this;
            synchronized (dataset) {
                if (this.browsers == null) {
                    this.browsers = this.getComponent("BrowserUA");
                }
            }
        }
        return this.browsers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component getCrawlers() throws IOException {
        if (this.crawlers == null) {
            Dataset dataset = this;
            synchronized (dataset) {
                if (this.crawlers == null) {
                    this.crawlers = this.getComponent("Crawler");
                }
            }
        }
        return this.crawlers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCopyright() throws IOException {
        if (this.copyright == null) {
            Dataset dataset = this;
            synchronized (dataset) {
                if (this.copyright == null) {
                    this.copyright = this.strings.get(this.copyrightOffset).toString();
                }
            }
        }
        return this.copyright;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() throws IOException {
        if (this.name == null) {
            Dataset dataset = this;
            synchronized (dataset) {
                if (this.name == null) {
                    this.name = this.strings.get(this.nameOffset).toString();
                }
            }
        }
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFormat() throws IOException {
        if (this.format == null) {
            Dataset dataset = this;
            synchronized (dataset) {
                if (this.format == null) {
                    this.format = this.strings.get(this.formatOffset).toString();
                }
            }
        }
        return this.format;
    }

    public ReadonlyList<Component> getComponents() {
        return this.components;
    }

    public ReadonlyList<Map> getMaps() {
        return this.maps;
    }

    public ReadonlyList<Property> getProperties() {
        return this.properties;
    }

    public ReadonlyList<Value> getValues() {
        return this.values;
    }

    public ReadonlyList<Signature> getSignatures() {
        return this.signatures;
    }

    public Dataset(BinaryReader binaryReader) throws IOException {
        this.version = new Version(binaryReader.readInt32(), binaryReader.readInt32(), binaryReader.readInt32(), binaryReader.readInt32());
        if (this.version.major != DetectionConstants.FormatVersion.major || this.version.minor != DetectionConstants.FormatVersion.minor) {
            throw new IOException(String.format("Version mismatch. Data is version '%s' for '%s' reader", this.version, DetectionConstants.FormatVersion));
        }
        this.guid = new Guid(binaryReader.readBytes(16));
        this.copyrightOffset = binaryReader.readInt32();
        this.age = binaryReader.readInt16();
        this.minUserAgentCount = binaryReader.readInt32();
        this.nameOffset = binaryReader.readInt32();
        this.formatOffset = binaryReader.readInt32();
        this.published = Dataset.readDate(binaryReader);
        this.nextUpdate = Dataset.readDate(binaryReader);
        this.deviceCombinations = binaryReader.readInt32();
        this.maxUserAgentLength = binaryReader.readInt16();
        this.minUserAgentLength = binaryReader.readInt16();
        this.lowestCharacter = binaryReader.readByte();
        this.highestCharacter = binaryReader.readByte();
        this.maxSignatures = binaryReader.readInt32();
        this.signatureProfilesCount = binaryReader.readInt32();
        this.signatureNodesCount = binaryReader.readInt32();
        this.maxValues = binaryReader.readInt16();
        this.csvBufferLength = binaryReader.readInt32();
        this.jsonBufferLength = binaryReader.readInt32();
        this.xmlBufferLength = binaryReader.readInt32();
        this.maxSignaturesClosest = binaryReader.readInt32();
        this.nodes = null;
    }

    private static Date readDate(BinaryReader binaryReader) {
        short s = binaryReader.readInt16();
        int n = binaryReader.readByte() - 1;
        byte by = binaryReader.readByte();
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.set(s, n, by);
        return calendar.getTime();
    }

    public ReadonlyList<Node> getNodes() {
        return this.nodes;
    }

    public ReadonlyList<Profile> getProfiles() {
        return this.profiles;
    }

    public short getMinUserAgentLength() {
        return this.minUserAgentLength;
    }

    public void init() throws IOException {
        this.name = this.strings.get(this.nameOffset).toString();
        this.format = this.strings.get(this.formatOffset).toString();
        this.copyright = this.strings.get(this.copyrightOffset).toString();
        for (Signature baseEntity : this.signatures) {
            baseEntity.init();
        }
        for (Node node : this.nodes) {
            node.init();
        }
        for (Profile profile : this.profiles) {
            profile.init();
        }
        for (Component component : this.getComponents()) {
            component.init();
        }
        for (Property property : this.getProperties()) {
            property.init();
        }
        for (Value value : this.values) {
            value.init();
        }
        this.strings.dispose();
        this.strings = null;
        this.profiles.dispose();
        this.profiles = null;
    }

    public Component getComponent(String string) throws IOException {
        for (Component component : this.components) {
            if (!string.equals(component.getName())) continue;
            return component;
        }
        return null;
    }

    public Property get(String string) throws IOException {
        for (Property property : this.properties) {
            if (!string.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    public int getProfilesCount() {
        return this.signatureProfilesCount;
    }

    public int getNodesCount() {
        return this.signatureNodesCount;
    }

    public Profile findProfile(int n) throws IOException {
        int n2 = 0;
        int n3 = this.profileOffsets.size() - 1;
        while (n2 <= n3) {
            int n4 = n2 + (n3 - n2) / 2;
            int n5 = this.profileOffsets.get(n4).getProfileId() - n;
            if (n5 == 0) {
                return this.profiles.get(this.profileOffsets.get(n4).getOffset());
            }
            if (n5 > 0) {
                n3 = n4 - 1;
                continue;
            }
            n2 = n4 + 1;
        }
        return null;
    }

    @Override
    public void dispose() {
        this.disposed = true;
        if (this.strings != null) {
            this.strings.dispose();
        }
        if (this.components != null) {
            this.components.dispose();
        }
        if (this.properties != null) {
            this.properties.dispose();
        }
        if (this.values != null) {
            this.values.dispose();
        }
        if (this.signatures != null) {
            this.signatures.dispose();
        }
        if (this.profiles != null) {
            this.profiles.dispose();
        }
        if (this.nodes != null) {
            this.nodes.dispose();
        }
        if (this.rootNodes != null) {
            this.rootNodes.dispose();
        }
    }
}

