/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection;

import fiftyone.mobile.detection.ClosestScore;
import fiftyone.mobile.detection.Match;
import fiftyone.mobile.detection.MatchMethods;
import fiftyone.mobile.detection.NearestScore;
import fiftyone.mobile.detection.entities.Node;
import fiftyone.mobile.detection.entities.Profile;
import java.io.IOException;

public class Controller {
    private static final NearestScore nearest = new NearestScore();
    private static final ClosestScore closest = new ClosestScore();

    public void match(Match match) throws IOException {
        if (match.getDataSet().getDisposed()) {
            throw new IllegalStateException("Data Set has been disposed and can't be used for match");
        }
        if (match.getTargetUserAgentArray().length == 0 || match.getTargetUserAgentArray().length < match.getDataSet().getMinUserAgentLength()) {
            this.matchDefault(match);
        } else {
            this.evaluate(match);
            int n = match.getExactSignatureIndex();
            if (n >= 0) {
                match.setSignature(match.getDataSet().signatures.get(n));
                match.method = MatchMethods.EXACT;
                match.setLowestScore(0);
            } else {
                this.evaluateNumeric(match);
                n = match.getExactSignatureIndex();
                if (n >= 0) {
                    match.setSignature(match.getDataSet().signatures.get(n));
                    match.method = MatchMethods.NUMERIC;
                } else if (match.getNodes().size() > 0) {
                    Match.RankedSignatureIterator rankedSignatureIterator = match.getClosestSignatures();
                    nearest.evaluateSignatures(match, rankedSignatureIterator);
                    if (match.getSignature() != null) {
                        match.method = MatchMethods.NEAREST;
                    } else {
                        closest.evaluateSignatures(match, rankedSignatureIterator);
                        match.method = MatchMethods.CLOSEST;
                    }
                }
            }
            if (match.getProfiles() == null && match.getSignature() == null) {
                this.matchDefault(match);
            }
        }
    }

    private void evaluateNumeric(Match match) throws IOException {
        match.resetNextCharacterPositionIndex();
        int n = match.getNodes().size() - 1;
        while (match.nextCharacterPositionIndex > 0) {
            if (n < 0 || match.getNodes().get((int)n).getRoot().position < match.nextCharacterPositionIndex) {
                ++match.rootNodesEvaluated;
                Node node = match.getDataSet().rootNodes.get(match.nextCharacterPositionIndex).getCompleteNumericNode(match);
                if (node != null && !node.getIsOverlap(match)) {
                    n = match.insertNode(node) - 1;
                    match.nextCharacterPositionIndex = node.position;
                    continue;
                }
                --match.nextCharacterPositionIndex;
                continue;
            }
            match.nextCharacterPositionIndex = match.getNodes().get((int)n).position;
            --n;
        }
    }

    private void matchDefault(Match match) throws IOException {
        match.method = MatchMethods.NONE;
        match.profiles = new Profile[match.getDataSet().components.size()];
        for (int i = 0; i < match.profiles.length; ++i) {
            match.profiles[i] = match.getDataSet().components.get(i).getDefaultProfile();
        }
    }

    private void evaluate(Match match) throws IOException {
        while (match.nextCharacterPositionIndex > 0) {
            ++match.rootNodesEvaluated;
            Node node = match.getDataSet().rootNodes.get(match.nextCharacterPositionIndex).getCompleteNode(match);
            if (node != null) {
                match.getNodes().add(0, node);
                match.nextCharacterPositionIndex = node.nextCharacterPosition;
                continue;
            }
            --match.nextCharacterPositionIndex;
        }
    }
}

