/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection;

import java.util.concurrent.ConcurrentHashMap;

class Cache<K, V> {
    private long nextCacheService;
    private int serviceIntervalMS;
    private ConcurrentHashMap<K, V> active;
    private ConcurrentHashMap<K, V> background;

    public Cache(int n) {
        this.serviceIntervalMS = n + 1000;
        this.nextCacheService = System.currentTimeMillis() + (long)this.serviceIntervalMS;
        this.active = new ConcurrentHashMap();
        this.background = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void service() {
        if (this.nextCacheService < System.currentTimeMillis()) {
            Cache cache = this;
            synchronized (cache) {
                if (this.nextCacheService < System.currentTimeMillis()) {
                    ConcurrentHashMap<K, V> concurrentHashMap = this.active;
                    this.active = this.background;
                    this.background = concurrentHashMap;
                    this.background.clear();
                    this.nextCacheService = System.currentTimeMillis() + (long)this.serviceIntervalMS;
                }
            }
        }
    }

    V tryGetValue(K k) {
        return this.active.get(k);
    }

    void setActive(K k, V v) {
        this.active.putIfAbsent(k, v);
    }

    void setBackground(K k, V v) {
        this.background.putIfAbsent(k, v);
        this.service();
    }
}

