/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection;

import fiftyone.mobile.detection.Match;
import fiftyone.mobile.detection.entities.Node;
import fiftyone.mobile.detection.entities.Signature;
import java.io.IOException;

abstract class BaseScore {
    BaseScore() {
    }

    protected abstract int getScore(Match var1, Node var2) throws IOException;

    protected abstract int getInitialScore(Match var1, Signature var2, int var3) throws IOException;

    void evaluateSignatures(Match match, Match.RankedSignatureIterator rankedSignatureIterator) throws IOException {
        rankedSignatureIterator.reset();
        match.setLowestScore(Integer.MAX_VALUE);
        short s = match.getNodes().get((int)(match.getNodes().size() - 1)).getRoot().position;
        for (int i = 0; rankedSignatureIterator.hasNext() && i < match.getDataSet().maxSignatures; ++i) {
            int n = rankedSignatureIterator.next();
            int n2 = match.getDataSet().rankedSignatureIndexes.get(n).getSignatureIndex();
            this.evaluateSignature(match, match.getDataSet().signatures.get(n2), s);
        }
    }

    private void evaluateSignature(Match match, Signature signature, int n) throws IOException {
        ++match.signaturesCompared;
        int n2 = this.getScore(match, signature, n);
        if (n2 < match.getLowestScore()) {
            match.setLowestScore(n2);
            match.setSignature(signature);
        }
    }

    private int getScore(Match match, Signature signature, int n) throws IOException {
        int n2 = this.getInitialScore(match, signature, n);
        int n3 = 0;
        int n4 = 0;
        while (n4 < signature.nodeOffsets.length && n2 < match.getLowestScore()) {
            int n5;
            int n6 = n3 >= match.getNodes().size() ? Integer.MAX_VALUE : match.getNodes().get(n3).getIndex();
            if (n6 > (n5 = signature.nodeOffsets[n4])) {
                int n7 = this.getScore(match, match.getDataSet().nodes.get(signature.nodeOffsets[n4]));
                if (n7 < 0) {
                    return Integer.MAX_VALUE;
                }
                n2 += n7;
                ++n4;
                continue;
            }
            if (n6 == n5) {
                ++n3;
                ++n4;
                continue;
            }
            if (n6 >= n5) continue;
            ++n3;
        }
        return n2;
    }
}

