/*
 * Decompiled with CFR 0.152.
 */
package fiftyone.mobile.detection;

import fiftyone.mobile.detection.AutoUpdateException;
import fiftyone.mobile.detection.Dataset;
import fiftyone.mobile.detection.factories.StreamFactory;
import fiftyone.properties.DetectionConstants;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.zip.DataFormatException;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HttpsURLConnection;

public class AutoUpdate {
    private static Dataset getNewDataset(String[] stringArray, String string) throws AutoUpdateException {
        try {
            Object object;
            Object object2;
            File file = new File(string);
            long l = -1L;
            if (file.exists() && !((Dataset)(object2 = StreamFactory.create(string))).getName().contains("Lite")) {
                l = file.lastModified();
            }
            if ((object2 = (Object)AutoUpdate.download(stringArray, l)) == null) {
                throw new AutoUpdateException("Device data download unsucessful. Update aborted.");
            }
            Dataset dataset = StreamFactory.create((byte[])object2);
            boolean bl = true;
            File file2 = new File(string);
            if (file2.exists()) {
                object = StreamFactory.create(string);
                boolean bl2 = bl = dataset.published.getTime() > ((Dataset)object).published.getTime() || dataset.getName() != ((Dataset)object).getName();
            }
            if (bl) {
                object = new FileOutputStream(file2);
                ((FileOutputStream)object).write((byte[])object2);
                ((FileOutputStream)object).close();
                file2.setLastModified(dataset.published.getTime());
                return dataset;
            }
        }
        catch (IOException iOException) {
            throw new AutoUpdateException(String.format("Exception reading data stream from server '%s'.", "https://51degrees.com/Products/Downloads/Premium.aspx") + iOException.getMessage());
        }
        return null;
    }

    private static String getMd5Hash(byte[] byArray) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return null;
        }
        byte[] byArray2 = messageDigest.digest(byArray);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray2.length; ++i) {
            stringBuilder.append(String.format("%02X ", byArray2[i]));
        }
        return stringBuilder.toString().toLowerCase().replaceAll(" ", "");
    }

    private static boolean validateMD5(HttpURLConnection httpURLConnection, byte[] byArray) {
        String string = httpURLConnection.getHeaderField("Content-MD5");
        String string2 = AutoUpdate.getMd5Hash(byArray);
        return string != null && string.equals(string2);
    }

    private static String joinString(String string, String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(stringArray[i]);
            if (i >= n - 1) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private static URL fullUrl(String[] stringArray) throws MalformedURLException {
        String[] stringArray2 = new String[]{"LicenseKeys=" + AutoUpdate.joinString("|", stringArray), "Download=True", "Type=BinaryV3"};
        String string = String.format("%s?%s", "https://51degrees.com/Products/Downloads/Premium.aspx", AutoUpdate.joinString("&", stringArray2));
        return new URL(string);
    }

    public static boolean update(String string, String string2) throws AutoUpdateException {
        return AutoUpdate.update(new String[]{string}, string2);
    }

    public static boolean update(String[] stringArray, String string) throws AutoUpdateException {
        if (stringArray == null || stringArray.length == 0) {
            throw new AutoUpdateException("Device data cannot be updated without a licence key.");
        }
        String[] stringArray2 = AutoUpdate.getValidKeys(stringArray);
        if (stringArray2.length > 0) {
            Dataset dataset = AutoUpdate.getNewDataset(stringArray2, string);
            return dataset != null;
        }
        throw new AutoUpdateException("The license key(s) provided were invalid.");
    }

    private static String[] getValidKeys(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : stringArray) {
            Matcher matcher = DetectionConstants.LICENSE_KEY_VALIDATION_REGEX.matcher(string);
            if (!matcher.matches()) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static byte[] download(String[] stringArray, long l) throws AutoUpdateException {
        HttpURLConnection httpURLConnection = null;
        try {
            Object object;
            httpURLConnection = (HttpsURLConnection)AutoUpdate.fullUrl(stringArray).openConnection();
            if (l != -1L) {
                object = new Date(l);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss z");
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                httpURLConnection.setRequestProperty("Last-Modified", simpleDateFormat.format((Date)object));
            }
            if (httpURLConnection.getResponseCode() != 200) throw new AutoUpdateException("Unable to connect with 51Degrees update server. The update server may be temporarily down or unreachable from this location.");
            object = new byte[httpURLConnection.getContentLength()];
            int n = 0;
            int n2 = httpURLConnection.getInputStream().read((byte[])object, n, ((Object)object).length - n);
            while (n2 >= 0) {
                n2 = httpURLConnection.getInputStream().read((byte[])object, n += n2, ((Object)object).length - n);
            }
            if (!AutoUpdate.validateMD5(httpURLConnection, (byte[])object)) throw new AutoUpdateException("Device data update does not match hash values.");
            try {
                byte[] byArray = AutoUpdate.decompressData((byte[])object);
                return byArray;
            }
            catch (DataFormatException dataFormatException) {
                try {
                    throw new AutoUpdateException("Device data could not be decompressed. It is probably corrupt.");
                }
                catch (IOException iOException) {
                    throw new AutoUpdateException("Device data download failed: " + iOException.getMessage());
                }
            }
        }
        finally {
            httpURLConnection.disconnect();
        }
    }

    private static byte[] decompressData(byte[] byArray) throws IOException, DataFormatException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        GZIPInputStream gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
        byte[] byArray2 = new byte[1024];
        while (gZIPInputStream.available() != 0) {
            int n = gZIPInputStream.read(byArray2);
            if (n <= 0) continue;
            byteArrayOutputStream.write(byArray2, 0, n);
        }
        byteArrayOutputStream.close();
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        return byArray3;
    }
}

