/*
 * Decompiled with CFR 0.152.
 */
package com.keenfin.audioview;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.MediaMetadataRetriever;
import android.net.Uri;
import android.text.TextUtils;
import com.keenfin.audioview.R;
import java.io.FileDescriptor;

public final class Util {
    public static String getTrackTitle(Context context, Object source) {
        MediaMetadataRetriever metaRetriever = new MediaMetadataRetriever();
        try {
            if (source instanceof String) {
                metaRetriever.setDataSource((String)source);
            }
            if (source instanceof Uri) {
                metaRetriever.setDataSource(context, (Uri)source);
            }
            if (source instanceof FileDescriptor) {
                metaRetriever.setDataSource((FileDescriptor)source);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        String artist = metaRetriever.extractMetadata(2);
        String title = metaRetriever.extractMetadata(7);
        metaRetriever.release();
        if (artist != null && !TextUtils.isEmpty((CharSequence)artist) && title != null && !TextUtils.isEmpty((CharSequence)title)) {
            return artist + " - " + title;
        }
        if ((artist == null || TextUtils.isEmpty((CharSequence)artist)) && title != null && !TextUtils.isEmpty((CharSequence)title)) {
            return title;
        }
        if (artist == null || TextUtils.isEmpty((CharSequence)artist)) {
            return context.getString(R.string.no_title);
        }
        return artist;
    }

    @SuppressLint(value={"DefaultLocale"})
    public static String formatTime(int millis) {
        if (millis < 0) {
            return "\u221e";
        }
        int min = 0;
        int hour = 0;
        if ((millis /= 1000) >= 60) {
            min = millis / 60;
            millis %= 60;
        }
        if (min >= 60) {
            hour = min / 60;
            min %= 60;
        }
        String result = "";
        if (hour > 0) {
            result = result + String.format("%02d:", hour);
        }
        result = result + String.format("%02d:%02d", min, millis);
        return result;
    }

    public static String formatDuration(int duration) {
        return duration > 0 ? Util.formatTime(duration) : "\u221e";
    }
}

