/*
 * Decompiled with CFR 0.152.
 */
package com.keenfin.audioview;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.FloatRange;
import android.support.annotation.Nullable;
import android.support.design.widget.FloatingActionButton;
import android.support.v4.content.ContextCompat;
import android.text.method.MovementMethod;
import android.text.method.ScrollingMovementMethod;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageButton;
import android.widget.ProgressBar;
import android.widget.SeekBar;
import android.widget.TextView;
import com.keenfin.audioview.AudioViewListener;
import com.keenfin.audioview.R;
import com.keenfin.audioview.Util;
import java.io.FileDescriptor;
import java.io.IOException;
import java.util.List;

public abstract class BaseAudioView
extends FrameLayout
implements View.OnClickListener {
    protected ImageButton mPlay;
    protected View mRewind;
    protected View mForward;
    protected TextView mTitle;
    protected TextView mTime;
    protected TextView mTotalTime;
    protected SeekBar mProgress;
    protected ProgressBar mIndeterminate;
    protected boolean mShowTitle = true;
    protected boolean mSelectControls = true;
    protected boolean mMinified = false;
    protected boolean mLoop = false;
    protected int mPrimaryColor = 0;
    protected int mCustomLayoutRes = 0;
    protected int mCustomPlayIconRes = 0;
    protected int mCustomPauseIconRes = 0;
    public AudioViewListener mAudioViewListener;

    public BaseAudioView(Context context) {
        super(context);
        this.init(null, null);
    }

    public BaseAudioView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public BaseAudioView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    protected void init(@Nullable Context context, AttributeSet attrs) {
        if (this.isInEditMode()) {
            return;
        }
        if (context != null && attrs != null) {
            TypedArray styleable2 = context.obtainStyledAttributes(attrs, R.styleable.BaseAudioView, 0, 0);
            this.mShowTitle = styleable2.getBoolean(R.styleable.BaseAudioView_showTitle, true);
            this.mSelectControls = styleable2.getBoolean(R.styleable.BaseAudioView_selectControls, true);
            this.mMinified = styleable2.getBoolean(R.styleable.BaseAudioView_minified, false);
            this.mCustomLayoutRes = styleable2.getResourceId(R.styleable.BaseAudioView_customLayout, 0);
            this.mCustomPlayIconRes = styleable2.getResourceId(R.styleable.BaseAudioView_customPlayIcon, R.drawable.ic_play_arrow_white_24dp);
            this.mCustomPauseIconRes = styleable2.getResourceId(R.styleable.BaseAudioView_customPauseIcon, R.drawable.ic_pause_white_24dp);
            if (styleable2.hasValue(R.styleable.BaseAudioView_primaryColor)) {
                this.mPrimaryColor = styleable2.getColor(R.styleable.BaseAudioView_primaryColor, -16777216);
            }
            if (styleable2.hasValue(R.styleable.BaseAudioView_minified) && this.mCustomLayoutRes != 0) {
                throw new RuntimeException("Minified attr should not be specified while using custom layout.");
            }
            styleable2.recycle();
        }
        int layout2 = this.mCustomLayoutRes != 0 ? this.mCustomLayoutRes : (this.mMinified ? R.layout.audioview_min : R.layout.audioview);
        View view = BaseAudioView.inflate((Context)this.getContext(), (int)layout2, null);
        this.addView(view);
        this.mPlay = (ImageButton)this.findViewById(R.id.play);
        this.mRewind = this.findViewById(R.id.rewind);
        this.mForward = this.findViewById(R.id.forward);
        if (!this.mSelectControls) {
            if (this.mRewind != null) {
                this.mRewind.setVisibility(8);
            }
            if (this.mForward != null) {
                this.mForward.setVisibility(8);
            }
        }
        this.mProgress = (SeekBar)this.findViewById(R.id.progress);
        this.mIndeterminate = (ProgressBar)this.findViewById(R.id.indeterminate);
        this.mTitle = (TextView)this.findViewById(R.id.title);
        if (this.mTitle != null) {
            this.mTitle.setSelected(true);
            this.mTitle.setMovementMethod((MovementMethod)new ScrollingMovementMethod());
            if (!this.mShowTitle) {
                this.mTitle.setVisibility(8);
            }
        }
        this.mTime = (TextView)this.findViewById(R.id.time);
        this.mTotalTime = (TextView)this.findViewById(R.id.total_time);
        this.mPlay.setOnClickListener((View.OnClickListener)this);
        if (this.mRewind != null) {
            this.mRewind.setOnClickListener((View.OnClickListener)this);
        }
        if (this.mForward != null) {
            this.mForward.setOnClickListener((View.OnClickListener)this);
        }
        if (this.mPrimaryColor != 0) {
            this.mProgress.getProgressDrawable().setColorFilter(this.mPrimaryColor, PorterDuff.Mode.MULTIPLY);
            this.mIndeterminate.getIndeterminateDrawable().setColorFilter(this.mPrimaryColor, PorterDuff.Mode.SRC_ATOP);
            if (Build.VERSION.SDK_INT >= 16) {
                this.mProgress.getThumb().setColorFilter(this.mPrimaryColor, PorterDuff.Mode.SRC_ATOP);
            } else {
                Drawable thumb = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.thumb);
                if (thumb != null) {
                    thumb.setColorFilter(this.mPrimaryColor, PorterDuff.Mode.SRC_ATOP);
                    this.mProgress.setThumb(thumb);
                }
            }
            if (this.mPlay instanceof FloatingActionButton) {
                FloatingActionButton mPlayFloating = (FloatingActionButton)this.mPlay;
                mPlayFloating.setBackgroundTintList(ColorStateList.valueOf((int)this.mPrimaryColor));
                mPlayFloating.setRippleColor(BaseAudioView.darkenColor(this.mPrimaryColor, 0.87f));
            }
        }
    }

    public void setUpControls() {
        this.mProgress.setProgress(0);
        this.mProgress.setVisibility(0);
        this.mIndeterminate.setVisibility(8);
        this.setPlayIcon();
        if (this.mTime != null) {
            this.mTime.setText((CharSequence)"");
        }
        if (this.mTotalTime != null) {
            this.mTotalTime.setText((CharSequence)"");
        }
        if (this.mTitle != null) {
            this.mTitle.setText((CharSequence)"");
        }
    }

    protected void setDuration(int duration) {
        String totalTime = Util.formatDuration(duration);
        if (duration > 0) {
            this.mProgress.setVisibility(0);
            this.mIndeterminate.setVisibility(8);
            this.mProgress.setProgress(0);
            this.mProgress.setMax(duration);
        } else {
            this.mProgress.setVisibility(8);
            this.mIndeterminate.setVisibility(0);
        }
        if (this.mTotalTime != null) {
            this.mTotalTime.setText((CharSequence)totalTime);
        } else if (this.mTime != null) {
            this.mTime.setText((CharSequence)totalTime);
        }
    }

    @ColorInt
    public static int darkenColor(@ColorInt int color, @FloatRange(from=0.0, to=1.0) float value) {
        float[] hsv = new float[3];
        Color.colorToHSV((int)color, (float[])hsv);
        hsv[2] = hsv[2] * value;
        return Color.HSVToColor((float[])hsv);
    }

    public void onClick(View v) {
    }

    public abstract void setDataSource(List var1) throws RuntimeException;

    public abstract void setDataSource(String var1) throws IOException;

    public abstract void setDataSource(Uri var1) throws IOException;

    public abstract void setDataSource(FileDescriptor var1) throws IOException;

    public abstract void start();

    public abstract void pause();

    public abstract void stop();

    public abstract void nextTrack();

    public abstract void previousTrack();

    public void setOnAudioViewListener(AudioViewListener audioViewListener) {
        this.mAudioViewListener = audioViewListener;
    }

    public void setLoop(boolean loop) {
        this.mLoop = loop;
    }

    protected void setPauseIcon() {
        this.mPlay.setImageResource(this.mCustomPauseIconRes);
    }

    protected void setPlayIcon() {
        this.mPlay.setImageResource(this.mCustomPlayIconRes);
    }
}

